/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.core.commons.file;

import com.github.ltsopensource.core.constant.Constants;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Writer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;

public class FileUtils {
    public static File createFileIfNotExist(File file) {
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                throw new RuntimeException("create file[" + file.getAbsolutePath() + "] failed!", e);
            }
        }
        return file;
    }

    public static FileChannel newFileChannel(File file, String mode) throws FileNotFoundException {
        return new RandomAccessFile(file, mode).getChannel();
    }

    public static File createFileIfNotExist(String path) {
        return FileUtils.createFileIfNotExist(new File(path));
    }

    public static File createDirIfNotExist(File dir) throws IOException {
        if (!dir.exists()) {
            dir.getParentFile().mkdirs();
            dir.mkdir();
        } else {
            if (!dir.isDirectory()) {
                throw new IOException("Not a directory [" + dir.getAbsolutePath() + "]");
            }
            if (!dir.canWrite()) {
                throw new IOException("Not writable [" + dir.getAbsolutePath() + "]");
            }
        }
        return dir.getAbsoluteFile();
    }

    public static File createDirIfNotExist(String path) throws IOException {
        return FileUtils.createDirIfNotExist(new File(path));
    }

    public static String read(InputStream is) throws IOException {
        return FileUtils.read(is, Charset.defaultCharset().name());
    }

    public static String read(InputStream is, String encoding) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(is, encoding));
        StringBuilder content = new StringBuilder();
        String data = null;
        while ((data = br.readLine()) != null) {
            content.append(data);
            content.append(Constants.LINE_SEPARATOR);
        }
        return content.toString();
    }

    public static void delete(File file) {
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            File[] delFiles = file.listFiles();
            if (delFiles == null || delFiles.length == 0) {
                file.delete();
            } else {
                for (File delFile : delFiles) {
                    if (delFile.isDirectory()) {
                        FileUtils.delete(delFile);
                    }
                    delFile.delete();
                }
            }
        }
        file.delete();
    }

    public static void delete(String path) {
        FileUtils.delete(new File(path));
    }

    public static void write(CharSequence charSequence, File file, Charset charset, boolean append) {
        Writer writer = null;
        try {
            FileUtils.createFileIfNotExist(file);
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file, append), charset);
            writer.append(charSequence);
            writer.flush();
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static boolean exist(String path) {
        return new File(path).exists();
    }

    public static long getSize(File file) {
        if (file.exists()) {
            if (!file.isFile()) {
                long size = 0L;
                File[] files = file.listFiles();
                if (files != null && files.length > 0) {
                    for (File f : files) {
                        size += FileUtils.getSize(f);
                    }
                }
                return size;
            }
            return file.length();
        }
        return 0L;
    }
}

