/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.autoconfigure.resolver;

import com.github.ltsopensource.autoconfigure.AutoConfigContext;
import com.github.ltsopensource.autoconfigure.PropertiesConfigurationResolveException;
import com.github.ltsopensource.autoconfigure.resolver.Resolver;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;

public abstract class AbstractResolver
implements Resolver {
    protected void doFilter(AutoConfigContext context, PropertyDescriptor descriptor, Filter filter) {
        Set<String> names = context.getNamesByDescriptor(descriptor);
        for (Map.Entry<String, String> entry : context.getPropMap().entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            for (String name : names) {
                if (!filter.onCondition(name, key, value)) continue;
                filter.call(name, key, value);
            }
        }
    }

    protected void writeProperty(AutoConfigContext context, PropertyDescriptor descriptor, Object value) {
        try {
            Method writeMethod = descriptor.getWriteMethod();
            writeMethod.invoke(context.getTargetObject(), value);
        }
        catch (Exception e) {
            throw new PropertiesConfigurationResolveException("Inject Property " + descriptor.getName() + " Error", e);
        }
    }

    protected static interface Filter {
        public boolean onCondition(String var1, String var2, String var3);

        public boolean call(String var1, String var2, String var3);
    }
}

