/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.autoconfigure;

import com.github.ltsopensource.autoconfigure.AutoConfigContext;
import com.github.ltsopensource.autoconfigure.AutoConfigContextBuilder;
import com.github.ltsopensource.autoconfigure.PropertiesConfigurationResolveException;
import com.github.ltsopensource.autoconfigure.annotation.ConfigurationProperties;
import com.github.ltsopensource.autoconfigure.resolver.Resolver;
import com.github.ltsopensource.autoconfigure.resolver.ResolverUtils;
import com.github.ltsopensource.core.commons.utils.CollectionUtils;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;

public class PropertiesConfigurationFactory {
    public static <T> T createPropertiesConfiguration(Class<T> clazz, Map<String, String> propMap) {
        if (clazz == null) {
            throw new IllegalArgumentException("clazz should not be null");
        }
        if (!clazz.isAnnotationPresent(ConfigurationProperties.class)) {
            throw new IllegalArgumentException(clazz.getName() + " must annotation with @" + ConfigurationProperties.class.getName());
        }
        ConfigurationProperties annotation = clazz.getAnnotation(ConfigurationProperties.class);
        String prefix = annotation.prefix();
        return PropertiesConfigurationFactory.createPropertiesConfiguration(clazz, prefix, propMap);
    }

    public static <T> T createPropertiesConfiguration(Class<T> clazz, String prefix, Map<String, String> propMap) {
        T targetObj;
        try {
            targetObj = clazz.newInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException(clazz.getName() + " instance error", e);
        }
        AutoConfigContext configContext = new AutoConfigContextBuilder().setPrefix(prefix).setPropMap(propMap).setTargetObj(targetObj).build();
        HashSet<String> includeNames = new HashSet<String>();
        if (CollectionUtils.isNotEmpty(configContext.getNameDescriptorMap())) {
            for (String key : propMap.keySet()) {
                for (String name : configContext.getNameDescriptorMap().keySet()) {
                    if (!key.startsWith(name)) continue;
                    includeNames.add(name);
                }
            }
        }
        for (String includeName : includeNames) {
            PropertyDescriptor descriptor = configContext.getNameDescriptorMap().get(includeName);
            Class<?> propertyType = descriptor.getPropertyType();
            Resolver resolver = ResolverUtils.getResolver(propertyType);
            if (resolver != null) {
                resolver.resolve(configContext, descriptor, propertyType);
                continue;
            }
            throw new PropertiesConfigurationResolveException("Can not find Resolver for type:" + propertyType.getName());
        }
        return targetObj;
    }

    public static <T> T createPropertiesConfiguration(Class<T> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("clazz should not be null");
        }
        if (!clazz.isAnnotationPresent(ConfigurationProperties.class)) {
            throw new IllegalArgumentException(clazz.getName() + " must annotation with @" + ConfigurationProperties.class.getName());
        }
        ConfigurationProperties annotation = clazz.getAnnotation(ConfigurationProperties.class);
        String[] locations = annotation.locations();
        return PropertiesConfigurationFactory.createPropertiesConfiguration(clazz, locations);
    }

    public static <T> T createPropertiesConfiguration(Class<T> clazz, String[] locations) {
        if (clazz == null) {
            throw new IllegalArgumentException("clazz should not be null");
        }
        if (!clazz.isAnnotationPresent(ConfigurationProperties.class)) {
            throw new IllegalArgumentException(clazz.getName() + " must annotation with @" + ConfigurationProperties.class.getName());
        }
        if (locations == null || locations.length == 0) {
            throw new IllegalArgumentException(clazz.getName() + " must specified the properties locations");
        }
        Properties properties = new Properties();
        for (String location : locations) {
            try {
                properties.load(PropertiesConfigurationFactory.class.getClassLoader().getResourceAsStream(location.trim()));
            }
            catch (IOException e) {
                throw new IllegalStateException("Load properties [" + location + "] error", e);
            }
        }
        HashMap<String, String> map = new HashMap<String, String>(properties.size());
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = entry.getKey().toString();
            String value = entry.getValue() == null ? null : entry.getValue().toString();
            if (value == null) continue;
            map.put(key, value);
        }
        return PropertiesConfigurationFactory.createPropertiesConfiguration(clazz, map);
    }
}

