/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.api.internal.util;

import com.aliyun.api.AliyunResponse;
import com.taobao.api.internal.util.TaobaoHashMap;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AliyunLogger {
    private static final Log clog = LogFactory.getLog((String)"sdk.comm.err");
    private static final Log blog = LogFactory.getLog((String)"sdk.biz.err");
    private static String osName = System.getProperties().getProperty("os.name");
    private static String ip = null;
    private static boolean needEnableLogger = true;

    public static void setNeedEnableLogger(boolean needEnableLogger) {
        AliyunLogger.needEnableLogger = needEnableLogger;
    }

    public static String getIp() {
        if (ip == null) {
            try {
                ip = InetAddress.getLocalHost().getHostAddress();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ip;
    }

    public static void setIp(String ip) {
        AliyunLogger.ip = ip;
    }

    public static void logCommError(Exception e, HttpURLConnection conn, String appKey, String method, byte[] content) {
        if (!needEnableLogger) {
            return;
        }
        String contentString = null;
        try {
            contentString = new String(content, "UTF-8");
            AliyunLogger.logCommError(e, conn, appKey, method, contentString);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    public static void logCommError(Exception e, String url, String appKey, String method, byte[] content) {
        if (!needEnableLogger) {
            return;
        }
        String contentString = null;
        try {
            contentString = new String(content, "UTF-8");
            AliyunLogger.logCommError(e, url, appKey, method, contentString);
        }
        catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
        }
    }

    public static void logCommError(Exception e, HttpURLConnection conn, String appKey, String method, Map<String, String> params) {
        if (!needEnableLogger) {
            return;
        }
        AliyunLogger._logCommError(e, conn, null, appKey, method, params);
    }

    public static void logCommError(Exception e, String url, String appKey, String method, Map<String, String> params) {
        if (!needEnableLogger) {
            return;
        }
        AliyunLogger._logCommError(e, null, url, appKey, method, params);
    }

    private static void logCommError(Exception e, HttpURLConnection conn, String appKey, String method, String content) {
        Map<String, String> params = AliyunLogger.parseParam(content);
        AliyunLogger._logCommError(e, conn, null, appKey, method, params);
    }

    private static void logCommError(Exception e, String url, String appKey, String method, String content) {
        Map<String, String> params = AliyunLogger.parseParam(content);
        AliyunLogger._logCommError(e, null, url, appKey, method, params);
    }

    private static void _logCommError(Exception e, HttpURLConnection conn, String url, String appKey, String method, Map<String, String> params) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        df.setTimeZone(TimeZone.getTimeZone("GMT+8"));
        String sdkName = "top-sdk-java-20210917";
        String urlStr = null;
        String rspCode = "";
        if (conn != null) {
            try {
                urlStr = conn.getURL().toString();
                rspCode = "HTTP_ERROR_" + conn.getResponseCode();
            }
            catch (IOException iOException) {}
        } else {
            urlStr = url;
            rspCode = "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(df.format(new Date()));
        sb.append("^_^");
        sb.append(method);
        sb.append("^_^");
        sb.append(appKey);
        sb.append("^_^");
        sb.append(AliyunLogger.getIp());
        sb.append("^_^");
        sb.append(osName);
        sb.append("^_^");
        sb.append(sdkName);
        sb.append("^_^");
        sb.append(urlStr);
        sb.append("^_^");
        sb.append(rspCode);
        sb.append("^_^");
        sb.append((e.getMessage() + "").replaceAll("\r\n", " "));
        clog.error((Object)sb.toString());
    }

    private static Map<String, String> parseParam(String contentString) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (contentString == null || contentString.trim().equals("")) {
            return params;
        }
        String[] paramsArray = contentString.split("\\&");
        if (paramsArray != null) {
            for (String param : paramsArray) {
                String[] keyValue = param.split("=");
                if (keyValue == null || keyValue.length != 2) continue;
                params.put(keyValue[0], keyValue[1]);
            }
        }
        return params;
    }

    public static void logBizError(String rsp) {
        if (!needEnableLogger) {
            return;
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        df.setTimeZone(TimeZone.getTimeZone("GMT+8"));
        StringBuilder sb = new StringBuilder();
        sb.append(df.format(new Date()));
        sb.append("^_^");
        sb.append(rsp);
        blog.error((Object)sb.toString());
    }

    public static void logErrorScene(Map<String, Object> rt, AliyunResponse tRsp, String appSecret) {
        if (!needEnableLogger) {
            return;
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        df.setTimeZone(TimeZone.getTimeZone("GMT+8"));
        StringBuilder sb = new StringBuilder();
        sb.append("ErrorScene");
        sb.append("^_^");
        sb.append(tRsp.getErrorCode());
        sb.append("^_^");
        sb.append("appSecret***");
        sb.append("^_^");
        sb.append(ip);
        sb.append("^_^");
        sb.append(osName);
        sb.append("^_^");
        sb.append(df.format(new Date()));
        sb.append("^_^");
        sb.append("ProtocalMustParams:");
        AliyunLogger.appendLog((TaobaoHashMap)rt.get("protocalMustParams"), sb);
        sb.append("^_^");
        sb.append("ProtocalOptParams:");
        AliyunLogger.appendLog((TaobaoHashMap)rt.get("protocalOptParams"), sb);
        sb.append("^_^");
        sb.append("ApplicationParams:");
        AliyunLogger.appendLog((TaobaoHashMap)rt.get("textParams"), sb);
        sb.append("^_^");
        sb.append("Body:");
        sb.append((String)rt.get("rsp"));
        blog.error((Object)sb.toString());
    }

    private static void appendLog(TaobaoHashMap map, StringBuilder sb) {
        boolean first = true;
        Set set = map.entrySet();
        for (Map.Entry entry : set) {
            if (!first) {
                sb.append("&");
            } else {
                first = false;
            }
            sb.append((String)entry.getKey()).append("=").append((String)entry.getValue());
        }
    }
}

