/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import com.facebook.presto.hadoop.$internal.com.google.common.base.Preconditions;
import com.facebook.presto.hadoop.$internal.com.google.common.base.Predicate;
import com.facebook.presto.hadoop.$internal.com.google.common.collect.Iterables;
import java.util.Iterator;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockCollection;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoContiguous;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorage;
import org.apache.hadoop.util.GSet;
import org.apache.hadoop.util.LightWeightGSet;

class BlocksMap {
    private final int capacity;
    private GSet<Block, BlockInfoContiguous> blocks;

    BlocksMap(int capacity) {
        this.capacity = capacity;
        this.blocks = new LightWeightGSet<Block, BlockInfoContiguous>(capacity){

            @Override
            public Iterator<BlockInfoContiguous> iterator() {
                LightWeightGSet.SetIterator iterator = new LightWeightGSet.SetIterator();
                iterator.setTrackModification(false);
                return iterator;
            }
        };
    }

    void close() {
        this.clear();
        this.blocks = null;
    }

    void clear() {
        if (this.blocks != null) {
            this.blocks.clear();
        }
    }

    BlockCollection getBlockCollection(Block b) {
        BlockInfoContiguous info = this.blocks.get(b);
        return info != null ? info.getBlockCollection() : null;
    }

    BlockInfoContiguous addBlockCollection(BlockInfoContiguous b, BlockCollection bc) {
        BlockInfoContiguous info = this.blocks.get(b);
        if (info != b) {
            info = b;
            this.blocks.put(info);
        }
        info.setBlockCollection(bc);
        return info;
    }

    void removeBlock(Block block) {
        BlockInfoContiguous blockInfo = this.blocks.remove(block);
        if (blockInfo == null) {
            return;
        }
        blockInfo.setBlockCollection(null);
        for (int idx = blockInfo.numNodes() - 1; idx >= 0; --idx) {
            DatanodeDescriptor dn = blockInfo.getDatanode(idx);
            dn.removeBlock(blockInfo);
        }
    }

    BlockInfoContiguous getStoredBlock(Block b) {
        return this.blocks.get(b);
    }

    Iterable<DatanodeStorageInfo> getStorages(Block b) {
        return this.getStorages(this.blocks.get(b));
    }

    Iterable<DatanodeStorageInfo> getStorages(Block b, final DatanodeStorage.State state) {
        return Iterables.filter(this.getStorages(this.blocks.get(b)), new Predicate<DatanodeStorageInfo>(){

            @Override
            public boolean apply(DatanodeStorageInfo storage) {
                return storage.getState() == state;
            }
        });
    }

    Iterable<DatanodeStorageInfo> getStorages(final BlockInfoContiguous storedBlock) {
        return new Iterable<DatanodeStorageInfo>(){

            @Override
            public Iterator<DatanodeStorageInfo> iterator() {
                return new StorageIterator(storedBlock);
            }
        };
    }

    int numNodes(Block b) {
        BlockInfoContiguous info = this.blocks.get(b);
        return info == null ? 0 : info.numNodes();
    }

    boolean removeNode(Block b, DatanodeDescriptor node) {
        BlockInfoContiguous info = this.blocks.get(b);
        if (info == null) {
            return false;
        }
        boolean removed = node.removeBlock(info);
        if (info.getDatanode(0) == null && info.getBlockCollection() == null) {
            this.blocks.remove(b);
        }
        return removed;
    }

    int size() {
        return this.blocks.size();
    }

    Iterable<BlockInfoContiguous> getBlocks() {
        return this.blocks;
    }

    int getCapacity() {
        return this.capacity;
    }

    BlockInfoContiguous replaceBlock(BlockInfoContiguous newBlock) {
        BlockInfoContiguous currentBlock = this.blocks.get(newBlock);
        assert (currentBlock != null) : "the block if not in blocksMap";
        for (int i = currentBlock.numNodes() - 1; i >= 0; --i) {
            DatanodeDescriptor dn = currentBlock.getDatanode(i);
            DatanodeStorageInfo storage = currentBlock.findStorageInfo(dn);
            boolean removed = storage.removeBlock(currentBlock);
            Preconditions.checkState(removed, "currentBlock not found.");
            DatanodeStorageInfo.AddBlockResult result = storage.addBlock(newBlock);
            Preconditions.checkState(result == DatanodeStorageInfo.AddBlockResult.ADDED, "newBlock already exists.");
        }
        this.blocks.put(newBlock);
        return newBlock;
    }

    private static class StorageIterator
    implements Iterator<DatanodeStorageInfo> {
        private final BlockInfoContiguous blockInfo;
        private int nextIdx = 0;

        StorageIterator(BlockInfoContiguous blkInfo) {
            this.blockInfo = blkInfo;
        }

        @Override
        public boolean hasNext() {
            return this.blockInfo != null && this.nextIdx < this.blockInfo.getCapacity() && this.blockInfo.getDatanode(this.nextIdx) != null;
        }

        @Override
        public DatanodeStorageInfo next() {
            return this.blockInfo.getStorageInfo(this.nextIdx++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Sorry. can't remove.");
        }
    }
}

