/*
 * Decompiled with CFR 0.152.
 */
package com.enation.app.javashop.core.security.buyer;

import com.enation.app.javashop.core.security.buyer.BuyerAuthenticationService;
import com.enation.app.javashop.framework.security.AuthenticationService;
import com.enation.app.javashop.framework.security.TokenAuthenticationFilter;
import com.enation.app.javashop.framework.security.impl.AbstractAuthenticationService;
import com.enation.app.javashop.framework.security.message.UserDisableReceiver;
import com.enation.app.javashop.framework.security.model.Role;
import com.enation.app.javashop.model.base.DomainHelper;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.security.web.header.HeaderWriter;
import org.springframework.security.web.header.writers.frameoptions.AllowFromStrategy;
import org.springframework.security.web.header.writers.frameoptions.StaticAllowFromStrategy;
import org.springframework.security.web.header.writers.frameoptions.XFrameOptionsHeaderWriter;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;

@Configuration
@EnableWebSecurity
@Order(value=3)
public class BuyerSecurityConfig
extends WebSecurityConfigurerAdapter {
    @Autowired
    private DomainHelper domainHelper;
    @Autowired
    private BuyerAuthenticationService buyerAuthenticationService;
    @Autowired
    private AccessDeniedHandler accessDeniedHandler;
    @Autowired
    private AuthenticationEntryPoint authenticationEntryPoint;
    @Autowired
    private List<AuthenticationService> authenticationServices;
    @Value(value="${spring.application.name}")
    private String applicationName;

    public void configure(HttpSecurity http) throws Exception {
        ((HttpSecurity)((HttpSecurity)((HttpSecurity)((HttpSecurity)((HttpSecurity)http.cors().and()).csrf().disable()).sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS).and()).exceptionHandling().accessDeniedHandler(this.accessDeniedHandler).authenticationEntryPoint(this.authenticationEntryPoint).and()).authorizeRequests().and()).addFilterBefore((Filter)new TokenAuthenticationFilter((AbstractAuthenticationService)this.buyerAuthenticationService), UsernamePasswordAuthenticationFilter.class);
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().antMatchers(new String[]{"/" + this.applicationName + "/v2/api-docs", "/" + this.applicationName + "/configuration/ui", "/" + this.applicationName + "/swagger-resources", "/" + this.applicationName + "/configuration/security", "/" + this.applicationName + "/swagger-ui.html", "/" + this.applicationName + "/webjars/**"})).anonymous();
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().antMatchers(new String[]{"/actuator/**", "/debugger/**", "/jquery.min.js", "/*order/pay/weixin/**", "/payment/**", "/order/pay/query/**", "/pintuan/orders/**", "/pintuan/goods", "/pintuan/goods/**", "/goods/**", "/pages/**", "/focus-pictures/**", "/nrsystem-app/swagger/**", "/shops/list", "/shops/{spring:[0-9]+}", "/shops/cats/{spring:[0-9]+}", "/shops/navigations/{spring:[0-9]+}", "/promotions/**", "/view", "/shops/sildes/{spring:[0-9]+}", "/members/logout*", "/passport/**", "/trade/goods/**", "/order/pay/return/**", "/members/asks/goods/{spring:[0-9]+}", "/members/asks/detail/{spring:[0-9]+}", "/members/asks/relation/{spring:[0-9]+}/{spring:[0-9]+}", "/members/asks/reply/list/{spring:[0-9]+}", "/members/comments/goods/{spring:[0-9]+}", "/members/comments/goods/{spring:[0-9]+}/count", "/distribution/su/**", "/passport/connect/pc/WECHAT/**", "/passport/login-binder/pc/**", "/account-binder/**", "/wechat/**", "/live-video/room/**", "/members/history", "/actuator/hystrix.stream", "/site-show", "/ueditor/**", "/regions/**", "/uploaders/**", "/captchas/**", "/client/**", "/load-customwords", "/validator", "/payment/**", "/self-service/**", "/trade/delivery/order/call-back", "/trade/checkout-params/**", "client/promotion/active/pre-sale/**", "/shops/sildes/store-list"})).permitAll().and();
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().anyRequest()).hasRole(Role.BUYER.name());
        http.headers().addHeaderWriter((HeaderWriter)this.xFrameOptionsHeaderWriter());
        http.headers().cacheControl();
    }

    public XFrameOptionsHeaderWriter xFrameOptionsHeaderWriter() throws URISyntaxException {
        String buyerDomain = this.domainHelper.getBuyerDomain();
        URI uri = new URI(buyerDomain);
        StaticAllowFromStrategy allowFromStrategy = new StaticAllowFromStrategy(uri);
        XFrameOptionsHeaderWriter xFrameOptionsHeaderWriter = new XFrameOptionsHeaderWriter((AllowFromStrategy)allowFromStrategy);
        return xFrameOptionsHeaderWriter;
    }

    @Bean
    public UserDisableReceiver userDisableReceiver() {
        return new UserDisableReceiver(this.authenticationServices);
    }

    @Bean
    CorsConfigurationSource corsConfigurationSource() {
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        CorsConfiguration config = new CorsConfiguration();
        config.setAllowCredentials(Boolean.valueOf(true));
        config.addAllowedOrigin("*");
        config.addAllowedHeader("*");
        config.addAllowedMethod("*");
        source.registerCorsConfiguration("/**", config);
        return source;
    }
}

