/*
 * Decompiled with CFR 0.152.
 */
package com.enation.app.javashop.core.client.feignimpl.trade;

import com.enation.app.javashop.client.trade.OrderClient;
import com.enation.app.javashop.core.client.hystrix.trade.OrderClientFallback;
import com.enation.app.javashop.model.trade.cart.dos.OrderPermission;
import com.enation.app.javashop.model.trade.order.dos.OrderDO;
import com.enation.app.javashop.model.trade.order.dos.OrderItemsDO;
import com.enation.app.javashop.model.trade.order.dos.OrderMetaDO;
import com.enation.app.javashop.model.trade.order.dto.OrderDetailDTO;
import com.enation.app.javashop.model.trade.order.enums.CommentStatusEnum;
import com.enation.app.javashop.model.trade.order.enums.OrderStatusEnum;
import com.enation.app.javashop.model.trade.order.vo.DeliveryVO;
import com.enation.app.javashop.model.trade.order.vo.OrderDetailVO;
import com.enation.app.javashop.model.trade.order.vo.OrderStatusNumVO;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(name="nrtrade-app", fallback=OrderClientFallback.class)
public interface OrderClientFeignImpl
extends OrderClient {
    @RequestMapping(value={"/client/orders/{order_sn}/detail"}, method={RequestMethod.GET})
    public OrderDetailVO getOrderVO(@PathVariable(value="order_sn") String var1);

    @RequestMapping(value={"/client/orders/{order_sn}"}, method={RequestMethod.GET})
    public OrderDetailDTO getModel(@PathVariable(value="order_sn") String var1);

    @RequestMapping(value={"/client/orders/{order_sn}/comment-status"}, method={RequestMethod.POST})
    public void updateOrderCommentStatus(@PathVariable(value="order_sn") String var1, @RequestParam(value="status_enum") String var2);

    @RequestMapping(value={"/client/orders/{trade_sn}/order-sku-list"}, method={RequestMethod.GET})
    public List<OrderDetailDTO> getOrderByTradeSn(@PathVariable(value="trade_sn") String var1);

    @RequestMapping(value={"/client/orders/{order_sn}/pay"}, method={RequestMethod.POST})
    public void payOrder(@PathVariable(value="order_sn") String var1, @RequestParam(value="price") Double var2, @RequestParam(value="return_trade_no") String var3, @RequestParam(value="permission") String var4);

    @RequestMapping(value={"/client/orders/{member_id}/order-num"}, method={RequestMethod.GET})
    public Integer getOrderNumByMemberID(@PathVariable(value="member_id") Long var1);

    @RequestMapping(value={"/client/orders/{member_id}/order-comment-num"}, method={RequestMethod.GET})
    public Integer getOrderCommentNumByMemberID(@PathVariable(value="member_id") Long var1, @RequestParam(value="comment_status") String var2);

    @RequestMapping(value={"/client/orders/order-status-num"}, method={RequestMethod.GET})
    public OrderStatusNumVO getOrderStatusNum(@RequestParam(value="member_id", required=false) Long var1, @RequestParam(value="seller_id", required=false) Long var2);

    @RequestMapping(value={"/client/orders/{sn}/order-status"}, method={RequestMethod.POST})
    public boolean updateOrderStatus(@PathVariable(value="sn") String var1, @RequestParam(value="order-status") OrderStatusEnum var2);

    @RequestMapping(value={"/client/orders/{sn}/trade-status"}, method={RequestMethod.POST})
    public boolean updateTradeStatus(@PathVariable(value="sn") String var1, @RequestParam(value="order-status") OrderStatusEnum var2);

    @RequestMapping(value={"/client/orders/item-refund-price"}, method={RequestMethod.POST})
    public void addOrderItemRefundPrice(@RequestBody OrderDO var1);

    @RequestMapping(value={"/client/orders/update-comment-status"}, method={RequestMethod.POST})
    public void updateItemsCommentStatus(@RequestParam(value="order_sn") String var1, @RequestParam(value="goods_id") Long var2, @RequestParam(value="comment_status") CommentStatusEnum var3);

    @RequestMapping(value={"/client/orders/order-items"}, method={RequestMethod.GET})
    public List<OrderItemsDO> orderItems(@RequestParam(value="order_sn") String var1);

    @RequestMapping(value={"/client/orders/{order_sn}/orderdo"}, method={RequestMethod.GET})
    public OrderDO getOrder(@PathVariable(value="order_sn") String var1);

    @RequestMapping(value={"/client/orders/ship"}, method={RequestMethod.POST})
    public void ship(@RequestBody DeliveryVO var1, @RequestParam(value="permission") OrderPermission var2);

    @GetMapping(value={"/client/orders/by-goods/{goods_id}"})
    public List<OrderDO> listOrderByGoods(@PathVariable(value="goods_id") Long var1, @RequestParam(value="member_id") Long var2, @RequestParam(value="month") Integer var3);

    @GetMapping(value={"/client/orders/promotion-typeand-num"})
    public List<Map> getItemsPromotionTypeandNum(@RequestParam(value="order_sn") String var1);

    @PostMapping(value={"/client/orders/save-meta"})
    public void insertOrderMeta(@RequestBody List<OrderMetaDO> var1);

    @GetMapping(value={"/client/orders/order-sync"})
    public Boolean orderSync(@RequestParam(value="order_sn") String var1);

    @GetMapping(value={"/client/orders/check-presale"})
    public void checkPresale(@RequestParam(value="order_sn") String var1);

    @PostMapping(value={"/client/orders/{order_sn}/receipt-void"})
    public String receiptVoid(@PathVariable(value="order_sn") String var1);
}

