/*
 * Decompiled with CFR 0.152.
 */
package org.rocksdb;

import org.rocksdb.AbstractCompactionFilter;
import org.rocksdb.AbstractCompactionFilterFactory;
import org.rocksdb.Logger;
import org.rocksdb.RocksObject;
import org.rocksdb.Slice;

public class FlinkCompactionFilter
extends AbstractCompactionFilter<Slice> {
    public FlinkCompactionFilter(ConfigHolder configHolder, TimeProvider timeProvider) {
        this(configHolder, timeProvider, null);
    }

    public FlinkCompactionFilter(ConfigHolder configHolder, TimeProvider timeProvider, Logger logger) {
        super(FlinkCompactionFilter.createNewFlinkCompactionFilter0(configHolder.nativeHandle_, timeProvider, logger == null ? 0L : logger.nativeHandle_));
    }

    private static native long createNewFlinkCompactionFilter0(long var0, TimeProvider var2, long var3);

    private static native long createNewFlinkCompactionFilterConfigHolder();

    private static native void disposeFlinkCompactionFilterConfigHolder(long var0);

    private static native boolean configureFlinkCompactionFilter(long var0, int var2, int var3, long var4, long var6, int var8, ListElementFilterFactory var9);

    public static class FlinkCompactionFilterFactory
    extends AbstractCompactionFilterFactory<FlinkCompactionFilter> {
        private final ConfigHolder configHolder = new ConfigHolder();
        private final TimeProvider timeProvider;
        private final Logger logger;

        public FlinkCompactionFilterFactory(TimeProvider timeProvider) {
            this(timeProvider, null);
        }

        public FlinkCompactionFilterFactory(TimeProvider timeProvider, Logger logger) {
            this.timeProvider = timeProvider;
            this.logger = logger;
        }

        @Override
        public void close() {
            super.close();
            this.configHolder.close();
            if (this.logger != null) {
                this.logger.close();
            }
        }

        @Override
        public FlinkCompactionFilter createCompactionFilter(AbstractCompactionFilter.Context context) {
            return new FlinkCompactionFilter(this.configHolder, this.timeProvider, this.logger);
        }

        @Override
        public String name() {
            return "FlinkCompactionFilterFactory";
        }

        public void configure(Config config) {
            boolean bl;
            boolean bl2 = bl = !FlinkCompactionFilter.configureFlinkCompactionFilter(this.configHolder.nativeHandle_, config.stateType.ordinal(), config.timestampOffset, config.ttl, config.queryTimeAfterNumEntries, config.fixedElementLength, config.listElementFilterFactory);
            if (bl) {
                throw new IllegalStateException("Compaction filter is already configured");
            }
        }
    }

    public static interface TimeProvider {
        public long currentTimestamp();
    }

    private static class ConfigHolder
    extends RocksObject {
        ConfigHolder() {
            super(FlinkCompactionFilter.createNewFlinkCompactionFilterConfigHolder());
        }

        @Override
        protected void disposeInternal(long l) {
            FlinkCompactionFilter.disposeFlinkCompactionFilterConfigHolder(l);
        }
    }

    public static class Config {
        final StateType stateType;
        final int timestampOffset;
        final long ttl;
        final long queryTimeAfterNumEntries;
        final int fixedElementLength;
        final ListElementFilterFactory listElementFilterFactory;

        private Config(StateType stateType, int n, long l, long l2, int n2, ListElementFilterFactory listElementFilterFactory) {
            this.stateType = stateType;
            this.timestampOffset = n;
            this.ttl = l;
            this.queryTimeAfterNumEntries = l2;
            this.fixedElementLength = n2;
            this.listElementFilterFactory = listElementFilterFactory;
        }

        public static Config createNotList(StateType stateType, int n, long l, long l2) {
            return new Config(stateType, n, l, l2, -1, null);
        }

        public static Config createForValue(long l, long l2) {
            return Config.createNotList(StateType.Value, 0, l, l2);
        }

        public static Config createForMap(long l, long l2) {
            return Config.createNotList(StateType.Value, 1, l, l2);
        }

        public static Config createForFixedElementList(long l, long l2, int n) {
            return new Config(StateType.List, 0, l, l2, n, null);
        }

        public static Config createForList(long l, long l2, ListElementFilterFactory listElementFilterFactory) {
            return new Config(StateType.List, 0, l, l2, -1, listElementFilterFactory);
        }
    }

    public static interface ListElementFilterFactory {
        public ListElementFilter createListElementFilter();
    }

    public static interface ListElementFilter {
        public int nextUnexpiredOffset(byte[] var1, long var2, long var4);
    }

    public static enum StateType {
        Disabled,
        Value,
        List;

    }
}

