package com.bizvane.wechat.feign.model.req;

import com.bizvane.wechat.feign.model.req.base.WxBaseAppIdReq;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;

@EqualsAndHashCode(callSuper = true)
@Data
public class WxCreateQRCodeReq extends WxBaseAppIdReq {

    /**
     * 扫码进入的小程序页面路径，最大长度 128 个字符，不能为空；对于小游戏，可以只传入 query 部分，来实现传参效果，如：传入 "?foo=bar"，即可在 wx.getLaunchOptionsSync 接口中的 query 参数获取到 {foo:"bar"}。scancode_time为系统保留参数，不允许配置。
     */
    @ApiModelProperty("扫码进入的小程序页面路径")
    @NotBlank(message = "path is not null")
    private String path;

    @ApiModelProperty(value = "二维码的宽度，单位 px。最小 280px，最大 1280px;默认是430")
    private int width = 430;
}
