package com.bizvane.wechat.feign.model.req;

import com.bizvane.wechat.feign.model.req.base.WxBaseAppIdReq;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;

@EqualsAndHashCode(callSuper = true)
@Data
public class WxGetUnlimitedQRCodeReq extends WxBaseAppIdReq {

    /**
     * scene 字段的值会作为 query 参数传递给小程序/小游戏。用户扫描该码进入小程序/小游戏后，开发者可以获取到二维码中的 scene 值，再做处理逻辑。
     * 最大32个可见字符，只支持数字，大小写英文以及部分特殊字
     */
    @ApiModelProperty("scene 字段的值会作为 query 参数传递给小程序/小游戏")
    @NotBlank(message = "scene is not null")
    private String scene;

    @ApiModelProperty(value = "二维码的宽度，单位 px。最小 280px，最大 1280px;默认是430")
    private Integer width;
    /**
     * 默认是主页，页面 page，例如 pages/index/index，根路径前不要填加 /，不能携带参数（参数请放在scene字段里），如果不填写这个字段，默认跳主页面。scancode_time为系统保留参数，不允许配置
     */
    @ApiModelProperty(value = "跳转页面，默认是主页，页面 page")
    private String page;
}
