package com.bizvane.wechat.feign.feign;

import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.wechat.feign.model.req.WxSendSubscribeMsgReq;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;


@FeignClient(value = "${feign.client.wechat.name}", path = "${feign.client.wechat.path}/wxSendMsg")
public interface WechatSendMsgRpcFeign {

    @PostMapping("/sendSubscribeMsg")
    @ResponseBody
    @ApiOperation(value = "发送订阅消息")
    ResponseData<Boolean> sendSubscribeMsg(@RequestBody @Validated WxSendSubscribeMsgReq req);
}
