package com.bizvane.tiktokmembers.facade.vo.rsp;

import lombok.Data;

import java.util.List;

@Data
public class Order {
    private AmountInfo amount_info;
    private Long anchor_id;
    private List<Certificate> certificate;
    private List<Contact> contacts;
    private Long count;
    private String craftsman_uid;
    //订单创建时间，10位时间戳，秒时间戳
    private Long create_order_time;
    private DeliveryInfo delivery_info;
    private Long discount_amount;
    private String intention_poi_id;
    // 商家信息
    private MerchantInfo merchant_info;
    //抖音内部用户的一种唯一标识
    private String open_id;
    //抖音订单ID
    private String order_id;
    /**
     * 订单状态
     *
     * （OrderStatus_Init 初始化 OrderStatus = 0
     *
     * OrderStatus_WaitPay 待支付 OrderStatus = 100
     *
     * OrderStatus_Cancel 订单关闭 OrderStatus = 101
     *
     * OrderStatus_PaySuccess 支付成功 OrderStatus = 200
     *
     * OrderStatus_Available 待使用 OrderStatus = 201
     *
     * OrderStatus_Finish 交易成功 OrderStatus = 1
     *
     * OrderStatus_PartPay 部分支付  OrderStatus = 150）
     */
    private Long order_status;
    //订单类型，21-团购，31-预售，41、90-外卖，51、70-次卡，60-券交易，100-预约品
    private Long order_type;
    //原始金额,单位分
    private Long original_amount;
    //实付金额，单位分。
    private Long pay_amount;
    //支付时间，10位时间戳，秒时间戳
    private Long pay_time;
    // 支付优惠
    private Long payment_discount;
    private PoiInfo poi;
    private String poi_id;
    private List<Product> products;
    private Long receipt_amount;
    private String room_id;
    private String sku_id;
    private String sku_name;
    private String third_sku_id;
    private Long update_order_time;
}