/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.exporttask.client.api;

import cn.bizvane.rocketmq.spring.core.producer.Destination;
import cn.bizvane.rocketmq.spring.core.producer.RocketMQTemplate;
import com.alibaba.fastjson.JSON;
import com.bizvane.exporttask.bean.CommonExportMessageVO;
import com.bizvane.exporttask.bean.DorisCommonExportMessageVO;
import com.bizvane.exporttask.common.bean.ResultBean;
import com.bizvane.exporttask.component.BaseComponent;
import com.bizvane.exporttask.dao.entity.FileTask;
import com.bizvane.exporttask.remote.dto.CommonExportVO;
import com.bizvane.exporttask.remote.dto.DorisCommonExportVO;
import com.bizvane.exporttask.remote.dto.FileTaskDto;
import com.bizvane.exporttask.remote.dto.FileTaskReq;
import com.bizvane.exporttask.remote.dto.base.PageListVo;
import com.bizvane.exporttask.remote.service.CommonExportFeignInterface;
import java.io.Serializable;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/common/export"})
@RestController
public class CommonExportService
implements CommonExportFeignInterface {
    private static final Logger log = LoggerFactory.getLogger(CommonExportService.class);
    @Autowired
    private BaseComponent baseComponent;
    @Autowired
    private RocketMQTemplate rocketMQTemplate;

    public ResultBean<Boolean> doExport(@RequestBody @Validated CommonExportVO dto) {
        log.info("\u5bfc\u51fa\u8bf7\u6c42\u5f00\u59cb\uff0c\u8bf7\u6c42\u5165\u53c2={}", (Object)JSON.toJSONString((Object)dto));
        ResultBean result = new ResultBean();
        result.setSuccess(Boolean.valueOf(true));
        result.setResult((Serializable)Boolean.valueOf(false));
        if (dto == null) {
            return result;
        }
        FileTask fileTask = this.baseComponent.insertTaskFile(dto.getSysBrandId(), dto.getSysCompanyId(), dto.getAccountId(), dto.getAccountName(), dto.getTaskName(), dto.getBusinessModule(), dto.getTaskType());
        if (fileTask == null) {
            return result;
        }
        CommonExportMessageVO messageVO = new CommonExportMessageVO();
        messageVO.setCommonExportVO(dto);
        messageVO.setTaskId(fileTask.getTaskId());
        try {
            this.rocketMQTemplate.send(Destination.builder().topic("TOPIC_EXPORT_COMMON").build(), (Object)messageVO);
        }
        catch (Exception e) {
            log.error("\u53d1\u9001\u5bfc\u51fa\u8bb0\u5f55MQ\u6d88\u606f\u5f02\u5e38,error={}", (Object)e.getMessage(), (Object)e);
            return result;
        }
        result.setResult((Serializable)Boolean.valueOf(true));
        log.info("\u5bfc\u51fa\u8bf7\u6c42\u7ed3\u675f\uff0c\u53d1\u9001MQ\u6d88\u606f\u7ed3\u679c={}", (Object)JSON.toJSONString((Object)result));
        return result;
    }

    public ResultBean<PageListVo<FileTaskDto>> pageList(@RequestBody @Validated FileTaskReq fileTaskReq) {
        return this.baseComponent.queryPageList(fileTaskReq);
    }

    public ResultBean<Boolean> dorisCommonExport(@RequestBody @Validated DorisCommonExportVO vo) {
        log.info("dorisCommonExport method execute start, vo:{}", (Object)JSON.toJSONString((Object)vo));
        ResultBean result = new ResultBean();
        result.setSuccess(Boolean.valueOf(true));
        result.setResult((Serializable)Boolean.valueOf(false));
        if (vo == null) {
            return result;
        }
        FileTask fileTask = this.baseComponent.insertTaskFile(vo.getSysBrandId(), vo.getSysCompanyId(), vo.getAccountId(), vo.getAccountName(), vo.getTaskName(), vo.getBusinessModule(), vo.getTaskType());
        if (fileTask == null) {
            return result;
        }
        DorisCommonExportMessageVO messageVO = new DorisCommonExportMessageVO();
        messageVO.setDorisCommonExportVO(vo);
        messageVO.setTaskId(fileTask.getTaskId());
        try {
            this.rocketMQTemplate.send(Destination.builder().topic("TOPIC_EXPORT_DORIS_COMMON").build(), (Object)messageVO);
        }
        catch (Exception e) {
            log.error("dorisCommonExport method execute error, topic is TOPIC_EXPORT_DORIS_COMMON, error={}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
            return result;
        }
        result.setResult((Serializable)Boolean.valueOf(true));
        log.info("dorisCommonExport method execute end\uff0cresult={}", (Object)JSON.toJSONString((Object)result));
        return result;
    }
}

