package com.bizvane.rights.vo.service;

import com.bizvane.rights.consts.BusinessConst;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

@Data
public class RightsSpecialPassengerFlightDetailVO implements Serializable {

    @ApiModelProperty("特殊旅客记录航班表code")
    private String rightsSpecialPassengerFlightCode;

    @ApiModelProperty("特殊旅客记录表code")
    private String rightsSpecialPassengerRecordCode;

    @ApiModelProperty("预计起飞时间")
    @JsonFormat(pattern = BusinessConst.YMDHMS, timezone = BusinessConst.TIMEZONE)
    private LocalDateTime estimatedDepartureTime;

    @ApiModelProperty("航班类型, 1，出发，2到达")
    private Integer flightType;

    @ApiModelProperty("航班编号")
    private String flightNumber;

    @ApiModelProperty("预约地点")
    private String appointmentLocation;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("创建人code")
    private String createUserCode;

    @ApiModelProperty("创建人")
    private String createUserName;

    @ApiModelProperty("创建日期")
    @JsonFormat(pattern = BusinessConst.YMDHMS, timezone = BusinessConst.TIMEZONE)
    private LocalDateTime createDate;

    @ApiModelProperty("修改人code")
    private String modifiedUserCode;

    @ApiModelProperty("修改人")
    private String modifiedUserName;

    @ApiModelProperty("修改时间")
    @JsonFormat(pattern = BusinessConst.YMDHMS, timezone = BusinessConst.TIMEZONE)
    private LocalDateTime modifiedDate;
}