package com.bizvane.rights.vo.staffbenefit;

import com.bizvane.rights.consts.BusinessConst;
import com.bizvane.rights.vo.PageVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.List;

@Data
public class QueryStaffBenefitPageReqVO extends PageVO {

    @ApiModelProperty("福利名称")
    private String benefitName;

    @ApiModelProperty("投放开始时间")
    @JsonFormat(pattern = BusinessConst.YMDHMS, timezone = BusinessConst.TIMEZONE)
    private LocalDateTime openStartTime;

    @ApiModelProperty("投放结束时间")
    @JsonFormat(pattern = BusinessConst.YMDHMS, timezone = BusinessConst.TIMEZONE)
    private LocalDateTime openEndTime;

    @ApiModelProperty("创建人名称")
    private String createUserName;

    @ApiModelProperty("创建开始时间")
    @JsonFormat(pattern = BusinessConst.YMDHMS, timezone = BusinessConst.TIMEZONE)
    private LocalDateTime createStartDate;

    @ApiModelProperty("创建结束时间")
    @JsonFormat(pattern = BusinessConst.YMDHMS, timezone = BusinessConst.TIMEZONE)
    private LocalDateTime createEndDate;

    @ApiModelProperty(value = "状态 0待上架 1上架中 2已下架 3已结束")
    private Integer state;

    @ApiModelProperty(value = "是否是组织限制")
    private boolean orgLimit;

    @ApiModelProperty(value = "账号所属组织code集合（包含子集）,从中台传递过来")
    private List<String> childrenOrgCodeList;

}
