package com.bizvane.rights.vo.service;

import com.bizvane.rights.consts.BusinessConst;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

@Data
public class RightsServiceRecordDetailResponseVO implements Serializable {

    @ApiModelProperty("服务记录主表code")
    private String rightsServiceRecordCode;

    @ApiModelProperty("会员code")
    private String mbrMembersCode;

    @ApiModelProperty("商户编号")
    private String merchantNo;

    @ApiModelProperty("服务类型1.特殊旅客服务  2.无障碍车位预约  3.行李门到门服务")
    private Integer serviceType;

    @ApiModelProperty("服务code")
    private String serviceCode;

    @ApiModelProperty("预约记录编号")
    private String reservationRecordNo;

    @ApiModelProperty("预约状态, 1=确认中,2=待使用,3=已完成,4=已取消")
    private Integer appointmentStatus;

    @ApiModelProperty("预约地点")
    private String appointmentLocation;

    @ApiModelProperty("预约时间")
    @JsonFormat(pattern = BusinessConst.YMDHMS, timezone = BusinessConst.TIMEZONE)
    private LocalDateTime appointmentTime;

    @ApiModelProperty("评价状态：false-未评价，true-已评价")
    private Boolean reviewStatus;

    @ApiModelProperty("服务对象类型,1-19 特殊旅客服务 20-29 无障碍车位预约 30-39 行李门到门 1=无陪年长旅客, 2=无障碍需求旅客, 3=孕妇旅客, 4=行动不便旅客, 5=无陪怀抱婴儿旅客")
    private Integer serviceTargetType;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("创建人code")
    private String createUserCode;

    @ApiModelProperty("创建人")
    private String createUserName;

    @ApiModelProperty("创建日期")
    @JsonFormat(pattern = BusinessConst.YMDHMS, timezone = BusinessConst.TIMEZONE)
    private LocalDateTime createDate;

    @ApiModelProperty("修改人code")
    private String modifiedUserCode;

    @ApiModelProperty("修改人")
    private String modifiedUserName;

    @ApiModelProperty("修改时间")
    @JsonFormat(pattern = BusinessConst.YMDHMS, timezone = BusinessConst.TIMEZONE)
    private LocalDateTime modifiedDate;
}
