package com.bizvane.rights.vo.hotel.order;

import com.bizvane.rights.consts.BusinessConst;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

@Data
public class RightsHotelOrderInfoDetailResponseVO implements Serializable {

    @ApiModelProperty("酒店订单code")
    private String rightsHotelOrderCode;

    @ApiModelProperty("酒店主体code")
    private String rightsHotelCode;

    @ApiModelProperty("酒店名称")
    private String hotelName;

    @ApiModelProperty("订单编号")
    private String orderNo;

    @ApiModelProperty("订单状态 1.待确认 2.已确认 3.已入住 4.已取消 5.待支付 6.退款中")
    private Integer orderStatus;

    @ApiModelProperty("预定姓名")
    private String reservationName;

    @ApiModelProperty("预定手机号脱敏")
    private String reservationPhone;

    @ApiModelProperty("预定手机号加密")
    private String reservationPhoneEncrypt;

    @ApiModelProperty("预计到店时间")
    @JsonFormat(pattern = BusinessConst.YMDHMS, timezone = BusinessConst.TIMEZONE)
    private LocalDateTime expectedArrivalTime;

    @ApiModelProperty("预计离店时间")
    @JsonFormat(pattern = BusinessConst.YMDHMS, timezone = BusinessConst.TIMEZONE)
    private LocalDateTime expectedCheckOutTime;

    @ApiModelProperty("预定时间")
    @JsonFormat(pattern = BusinessConst.YMDHMS, timezone = BusinessConst.TIMEZONE)
    private LocalDateTime reservationTime;

    @ApiModelProperty("会员code")
    private String memberCode;

    @ApiModelProperty("订单总价")
    private BigDecimal totalPrices;

    @ApiModelProperty("确认人code")
    private String confirmerUserCode;

    @ApiModelProperty("创建人name")
    private String confirmerUserName;

    @ApiModelProperty("确认时间")
    @JsonFormat(pattern = BusinessConst.YMDHMS, timezone = BusinessConst.TIMEZONE)
    private LocalDateTime confirmTime;

    @ApiModelProperty("办理入住人code")
    private String checkInUserCode;

    @ApiModelProperty("办理入住人name")
    private String checkInUserName;

    @ApiModelProperty("办理入住时间")
    @JsonFormat(pattern = BusinessConst.YMDHMS, timezone = BusinessConst.TIMEZONE)
    private LocalDateTime checkInTime;

    @ApiModelProperty("取消类型 1.用户取消 2.后台取消")
    private Integer cancellationType;

    @ApiModelProperty("取消时间")
    @JsonFormat(pattern = BusinessConst.YMDHMS, timezone = BusinessConst.TIMEZONE)
    private LocalDateTime cancellationTime;

    @ApiModelProperty("取消人code")
    private String cancellationUserCode;

    @ApiModelProperty("取消人name")
    private String cancellationUserName;

    @ApiModelProperty("支付状态 1.入住时支付 2.微信支付")
    private Integer payType;

    @ApiModelProperty("预定类型 1.员工预定 2.会员预定")
    private Integer reservationType;

    @ApiModelProperty("是否评价：1=未评价；2=已评价")
    private Integer evaluationStatus;

    @ApiModelProperty("房型名称")
    private String roomTypeName;

    @ApiModelProperty("酒店房型code")
    private String rightsHotelRoomTypeCode;

    @ApiModelProperty("数量")
    private Integer quantity;

    @ApiModelProperty("处理说明")
    private String handlingInstructions;

    @ApiModelProperty("优惠券号")
    private String couponNo;

    @ApiModelProperty("优惠金额")
    private BigDecimal discountAmount;

    @ApiModelProperty("支付金额")
    private BigDecimal payableAmount;

    @ApiModelProperty("已退金额")
    private BigDecimal refundAmount;

    @ApiModelProperty("是否退券 1.退券 0.不退")
    private Boolean isCouponRefunded;

    @ApiModelProperty("退款说明")
    private String refundNote;

}
