package com.bizvane.rights.feign;

import com.alibaba.fastjson.JSONObject;
import com.bizvane.rights.vo.hotel.order.*;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 酒店订单feign接口
 * @author liuying
 */
@Api(value = "酒店订单", tags = "酒店订单")
@FeignClient(value = "${feign.client.rights.name}", path = "${feign.client.rights.path}/hotelOrder")
public interface HotelOrderFeign {

    /**
     * 1.查询订单列表 --
     * 2.批量确认订单 --
     * 3.批量拒绝订单 --
     * 4.单条确认/拒绝订单
     * 4.解密手机号
     * 5.批量入住订单 --
     * 6.单条入住/取消订单
     *
     */

    @ApiOperation(value = "查询订单列表", notes = "查询订单列表", httpMethod = "POST")
    @PostMapping("page")
    ResponseData<PageInfo<RightsHotelOrderInfoDetailResponseVO>> page(@RequestBody RightsHotelOrderInfoPageRequestVO requestVO);

    @ApiOperation(value = "订单统计", notes = "订单统计", httpMethod = "POST")
    @PostMapping("statistics")
    ResponseData<RightsHotelOrderStatisticsResponseVO> statistics(@RequestBody RightsHotelOrderInfoPageRequestVO requestVO);

    @ApiOperation(value = "待确认数量", notes = "待确认数量", httpMethod = "POST")
    @PostMapping("countToBeConfirmed")
    ResponseData<Long> countToBeConfirmed(@RequestBody RightsHotelOrderInfoPageRequestVO requestVO);

    @ApiOperation(value = "批量拒绝订单", notes = "批量拒绝订单", httpMethod = "POST")
    @PostMapping("batchReject")
    @Deprecated
    ResponseData<RightsHotelBatchOperateOrdersResponseVO> batchReject(@RequestBody RightsHotelBatchOperateOrdersRequestVO requestVO);

    @ApiOperation(value = "批量确认订单", notes = "批量确认订单", httpMethod = "POST")
    @PostMapping("batchConfirm")
    ResponseData<RightsHotelBatchOperateOrdersResponseVO> batchConfirm(@RequestBody RightsHotelBatchOperateOrdersRequestVO requestVO);

    @ApiOperation(value = "批量入住订单", notes = "批量入住订单", httpMethod = "POST")
    @PostMapping("batchCheckIn")
    ResponseData<RightsHotelBatchOperateOrdersResponseVO> batchCheckIn(@RequestBody RightsHotelBatchOperateOrdersRequestVO requestVO);

    @ApiOperation(value = "单条拒绝订单", notes = "单条拒绝订单", httpMethod = "POST")
    @PostMapping("singleReject")
    ResponseData<RightsHotelOperateOrdersResponseVO> singleReject(@RequestBody RightsHotelOperateOrdersRequestVO requestVO);

    @ApiOperation(value = "取消已确认订单", notes = "取消已确认订单", httpMethod = "POST")
    @PostMapping("cancelConfirmedOrder")
    ResponseData<RightsHotelConfirmOrderCancellationResponseVO> cancelConfirmedOrder(@RequestBody RightsHotelConfirmOrderCancellationRequestVO requestVO);

    @ApiOperation(value = "单条确认订单", notes = "单条确认订单", httpMethod = "POST")
    @PostMapping("singleConfirm")
    ResponseData<RightsHotelOperateOrdersResponseVO> singleConfirm(@RequestBody RightsHotelOperateOrdersRequestVO requestVO);

    @ApiOperation(value = "单条确认/拒绝订单", notes = "单条确认/拒绝订单", httpMethod = "POST")
    @PostMapping("singleConfirmOrReject")
    ResponseData<RightsHotelOperateOrdersResponseVO> singleConfirmOrReject(@RequestBody RightsHotelOperateOrdersRequestVO requestVO);

    @ApiOperation(value = "单条入住订单", notes = "单条入住订单", httpMethod = "POST")
    @PostMapping("singleCheckIn")
    ResponseData<RightsHotelOperateOrdersResponseVO> singleCheckIn(@RequestBody RightsHotelOperateOrdersRequestVO requestVO);

    @ApiOperation(value = "订单明细带评价", notes = "订单明细带评价", httpMethod = "POST")
    @PostMapping("detailWithEvaluate")
    ResponseData<RightsHotelOrderWithEvaluateResponseVO> detailWithEvaluate(@RequestBody RightsHotelOrderWithEvaluateRequestVO requestVO);

    @ApiOperation(value = "订单明细带会员", notes = "订单明细带会员", httpMethod = "POST")
    @PostMapping("detailWithMember")
    ResponseData<RightsHotelOrderWithMemberResponseVO> detailWithMember(@RequestBody RightsHotelOrderWithMemberRequestVO requestVO);

    @ApiOperation(value = "酒店订单退款回调", notes = "酒店订单退款回调", httpMethod = "POST")
    @PostMapping("refundCallback")
    ResponseData<RightsHotelOrderRefundResponseVO> refundCallback(@RequestBody JSONObject requestVO);

    @ApiOperation(value = "酒店订单付款回调", notes = "酒店订单付款", httpMethod = "POST")
    @PostMapping("paymentCallback")
    ResponseData<RightsHotelOrderRefundResponseVO> paymentCallback(@RequestBody JSONObject requestVO);

}
