package com.bizvane.rights.feign;

import com.bizvane.rights.vo.evaluate.RightEvaluateAddRequestVO;
import com.bizvane.rights.vo.evaluate.RightEvaluateAddResponseVO;
import com.bizvane.rights.vo.evaluate.RightEvaluateRequestVO;
import com.bizvane.rights.vo.evaluate.RightEvaluateResponseVO;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 评价feign
 *
 */
@Api(value = "评价", tags = "评价")
@FeignClient(value = "${feign.client.rights.name}", path = "${feign.client.rights.path}/evaluate")
public interface EvaluateFeign {


    @ApiOperation(value = "查询评价列表", notes = "查询评价列表", httpMethod = "POST")
    @PostMapping("page")
    ResponseData<PageInfo<RightEvaluateResponseVO>> page(@RequestBody RightEvaluateRequestVO requestVO);



    @ApiOperation(value = "新增评价", notes = "新增评价", httpMethod = "POST")
    @PostMapping("add")
    ResponseData<RightEvaluateAddResponseVO> add(@RequestBody RightEvaluateAddRequestVO requestVO);



    @ApiOperation(value = "根据评价类型和订单编号查询评价内容", notes = "根据评价类型和订单编号查询评价内容", httpMethod = "POST")
    @PostMapping("detailByTypeAndOrderNo")
    ResponseData<RightEvaluateResponseVO> detailByTypeAndOrderNo(@RequestBody RightEvaluateRequestVO requestVO);



}
