package com.bizvane.rights.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

@Getter
public enum TransitBenefitsRightsTypeEnum {

    DOMESTIC_ARRIVAL (1, "国内到达权益",1,TransitTypeEnum.ARRIVE),
    INTERNATIONAL_ARRIVAL(2,"国际到达权益",2,TransitTypeEnum.ARRIVE),
    INTERNATIONAL_TO_DOMESTIC(3,"国际中转国内权益",5,TransitTypeEnum.TRANSFER),
    INTERNATIONAL_TO_INTERNATIONAL(4,"国际中转国际权益",6,TransitTypeEnum.TRANSFER),
    DOMESTIC_TO_DOMESTIC(5,"国内中转国内权益",3,TransitTypeEnum.TRANSFER),
    DOMESTIC_TO_INTERNATIONAL(6,"国内中转国际权益",4,TransitTypeEnum.TRANSFER);

    private Integer type;

    private String desc;

    private Integer mbrTransitType;
    private TransitTypeEnum transitTypeEnum;

    TransitBenefitsRightsTypeEnum(Integer type, String desc, Integer mbrTransitType, TransitTypeEnum transitTypeEnum) {
        this.type = type;
        this.desc = desc;
        this.mbrTransitType = mbrTransitType;
        this.transitTypeEnum = transitTypeEnum;
    }

    TransitBenefitsRightsTypeEnum(Integer type, String desc, Integer mbrTransitType) {
        this.type = type;
        this.desc = desc;
        this.mbrTransitType = mbrTransitType;
    }

    TransitBenefitsRightsTypeEnum(Integer code, String description) {
        this.type = code;
        this.desc = description;
    }
    public static TransitBenefitsRightsTypeEnum typeOf(Integer type){
        if(type == null){
            return null;
        }

        for (TransitBenefitsRightsTypeEnum value : values()) {
            if(value.getType().compareTo(type) == 0){
                return value;
            }
        }
        return null;
    }

    public static TransitBenefitsRightsTypeEnum typeOfMbrTransitType(Integer mbrTransitType){
        if(mbrTransitType == null){
            return null;
        }
        for (TransitBenefitsRightsTypeEnum value : values()) {
            if(value.getMbrTransitType().compareTo(mbrTransitType) == 0){
                return value;
            }
        }
        return null;
    }

    public final static Integer TYPE_COUPON = 1;
}
