package com.bizvane.rights.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

@AllArgsConstructor
@Getter
public enum HotelOrderPayTypeEnum {

    CHECK_IN_PAY(1, "入住时支付"),
    WECHAT_PAY(2, "微信支付");

    private Integer type;

    private String desc;

    public static HotelOrderPayTypeEnum fromType(Integer type) {
        for (HotelOrderPayTypeEnum hotelOrderPayTypeEnum : HotelOrderPayTypeEnum.values()) {
            if (hotelOrderPayTypeEnum.getType().equals(type)) {
                return hotelOrderPayTypeEnum;
            }
        }
        return null;
    }
}
