package com.bizvane.rights.feign;

import com.bizvane.rights.vo.evaluate.*;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;


/**
 * 酒店主体feign
 *
 * @author liuying
 */
@Api(value = "评价标签", tags = "评价标签")
@FeignClient(value = "${feign.client.rights.name}", path = "${feign.client.rights.path}/evaluateLabel")
public interface EvaluateLabelFeign {


    /**
     * 评价标签查询列表
     *
     * @return
     */
    @ApiOperation(value = "查询全部标签", notes = "查询全部标签", httpMethod = "GET")
    @GetMapping("listAll")
    ResponseData<List<EvaluateLabelGroupResponseVO>> listAll();


    /**
     * 删除评价标签
     */
    @ApiOperation(value = "禁用评价标签", notes = "禁用评价标签", httpMethod = "POST")
    @PostMapping("updateVaild")
    ResponseData<RightEvaluateLabelResponseVO> updateVaild(@RequestBody EvaluateLabelRequestVO requestVO);


    /**
     * 评价标签新增
     */
    @ApiOperation(value = "评价标签新增", notes = "评价标签新增", httpMethod = "POST")
    @PostMapping("add")
    ResponseData<RightEvaluateLabelResponseVO> add(@RequestBody EvaluateLabelAddRequestVO requestVO);


    /**
     * 通过标签code查标签name
     */
    @ApiOperation(value = "通过标签code查标签name", notes = "通过标签code查标签name", httpMethod = "GET")
    @GetMapping("detailByCode")
    ResponseData<EvaluateLabelResponseVO> detailByCode(@RequestParam("rightsHotelRoomTypeCode") String rightsEvaluateLabelCode);


    /**
     * 通过标签类型查标签
     */
    @ApiOperation(value = "通过标签类型查标签", notes = "通过标签类型查标签", httpMethod = "GET")
    @GetMapping("detailByLabelType")
    ResponseData<List<EvaluateLabelResponseVO>> detailByLabelType(@RequestParam("labelType") Integer labelType);








//    /**
//     * 评价标签更新
//     * @param requestVO
//     * @return
//     */
//    @ApiOperation(value = "评价标签更新", notes = "评价标签更新", httpMethod = "POST")
//    @PostMapping("update")
//    ResponseData<EvaluateLabelResponseVO> update(@RequestBody EvaluateLabelRequestVO requestVO);







}
