package com.bizvane.rights.vo.steward;

import com.bizvane.rights.consts.BusinessConst;
import com.bizvane.rights.vo.PageVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDate;
import java.time.LocalDateTime;

@Data
public class StewardQueryReqVO extends PageVO {
    @ApiModelProperty("服务名字")
    private String name;

    @ApiModelProperty("1-启用，2-禁用")
    private Integer status;

    @JsonFormat(pattern = BusinessConst.YMDHMS, timezone = BusinessConst.TIMEZONE)
    @ApiModelProperty("创建时间开始")
    private LocalDateTime createDateStart;

    @JsonFormat(pattern = BusinessConst.YMDHMS, timezone = BusinessConst.TIMEZONE)
    @ApiModelProperty("创建时间结束")
    private LocalDateTime createDateEnd;

    @ApiModelProperty("修改时间开始")
    @JsonFormat(pattern = BusinessConst.YMDHMS, timezone = BusinessConst.TIMEZONE)
    private LocalDateTime modifiedDateStart;

    @ApiModelProperty("修改时间结束")
    @JsonFormat(pattern = BusinessConst.YMDHMS, timezone = BusinessConst.TIMEZONE)
    private LocalDateTime modifiedDateEnd;
}
