package com.bizvane.rights.vo.hotel.roomsituation;

import com.bizvane.rights.consts.BusinessConst;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDate;

@Data
public class RightsHotelRoomSituationDetailResponseVO implements Serializable {

    @ApiModelProperty("酒店房态code")
    private String rightsHotelRoomSituationCode;

    @ApiModelProperty("酒店房型code")
    private String rightsHotelRoomTypeCode;

    @ApiModelProperty("酒店主体code")
    private String rightsHotelCode;

    @ApiModelProperty("日期")
    @JsonFormat(pattern = BusinessConst.YMD, timezone = BusinessConst.TIMEZONE)
    private LocalDate dayDate;

    @ApiModelProperty("总库存")
    private Integer totalStock;

    @ApiModelProperty("销量")
    private Integer salesVolume;

    @ApiModelProperty("可用库存")
    private Integer availableStock;
}
