package com.bizvane.rights.vo.hotel.order;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

@Data
public class RightsHotelOrderPaymentRequestVO implements Serializable {

    @ApiModelProperty("订单总金额，单位为元 保留两位小数。")
    private BigDecimal total;
    @ApiModelProperty("用户支付金额，单位为元 保留两位小数。")
    private BigDecimal payerTotal;
    @ApiModelProperty("直连商户申请的公众号或移动应用AppID。")
    private String appid;
    @ApiModelProperty("附加数据，在查询API和支付通知中原样返回，可作为自定义参数使用，实际情况下只有支付完成状态才会返回该字段。")
    private String attach;
    @ApiModelProperty("银行类型，采用字符串类型的银行标识。")
    private String bankType;
    @ApiModelProperty("商户的商户号，由微信支付生成并下发。")
    private String mchid;
    @ApiModelProperty("商户系统内部的订单号，当没提供out_trade_no时，系统自动生成一个唯一的订单号作为out_trade_no返回。")
    private String outTradeNo;
    @ApiModelProperty("用户在直连商户appid下的唯一标识。")
    private String openid;
    @ApiModelProperty("支付完成时间，遵循rfc3339标准格式。")
    private String successTime;
    @ApiModelProperty("【交易状态】 交易状态，详细业务流转状态处理请参考开发指引-订单状态流转图。枚举值：\nSUCCESS：支付成功\nREFUND：转入退款\nNOTPAY：未支付\nCLOSED：已关闭\nREVOKED：已撤销（仅付款码支付会返回）\nUSERPAYING：用户支付中（仅付款码支付会返回）\nPAYERROR：支付失败（仅付款码支付会返回）")
    private String tradeState;
    @ApiModelProperty("交易状态描述")
    private String tradeStateDesc;
    @ApiModelProperty("交易类型，枚举值：\nJSAPI：公众号支付\nNATIVE：扫码支付\nApp：App支付\nMICROPAY：付款码支付\nMWEB：H5支付\nFACEPAY：刷脸支付")
    private String tradeType;
    @ApiModelProperty("微信支付系统生成的订单号")
    private String transactionId;
}
