package com.bizvane.rights.feign;

import com.bizvane.rights.vo.hotel.*;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;


/**
 * 酒店主体feign
 *
 * @author liuying
 */
@Api(value = "酒店主体", tags = "酒店主体")
@FeignClient(value = "${feign.client.rights.name}", path = "${feign.client.rights.path}/hotel")
public interface HotelFeign {

    /**
     * 1.酒店主体查询列表,无需分页
     * 2.酒店主体查询明细
     * 3.酒店主体新增
     * 4.酒店主体更新
     * 5.酒店主体禁用
     * 6.酒店查询全部列表
     */
    @ApiOperation(value = "code查询酒店详情", notes = "code查询酒店详情", httpMethod = "GET")
    @GetMapping("detailByCode")
    ResponseData<RightsHotelDetailResponseVO> detail(@RequestParam("rightsHotelCode") String rightsHotelCode,@RequestParam("orgCodeList") List<String> orgCodeList);

    @ApiOperation(value = "查询全部列表酒店", notes = "查询全部列表酒店", httpMethod = "GET")
    @GetMapping("listAll")
    ResponseData<List<RightsHotelDetailResponseVO>> listAll(@RequestParam("orgCodeList") List<String> orgCodeList);

    @ApiOperation(value = "酒店主体查询列表,无需分页", notes = "酒店主体查询列表,无需分页", httpMethod = "POST")
    @PostMapping("listByCondition")
    ResponseData<List<RightsHotelDetailResponseVO>> listByCondition(@RequestBody RightsHotelConditionRequestVO requestVO);

    @ApiOperation(value = "酒店主体新增", notes = "酒店主体新增", httpMethod = "POST")
    @PostMapping("add")
    ResponseData<RightsHotelAddResponseVO> add(@RequestBody RightsHotelAddRequestVO requestVO);

    @ApiOperation(value = "酒店主体更新", notes = "酒店主体更新", httpMethod = "POST")
    @PostMapping("update")
    ResponseData<RightsHotelUpdateResponseVO> update(@RequestBody RightsHotelUpdateRequestVO requestVO);

    @ApiOperation(value = "酒店主体修改启用状态", notes = "酒店主体修改启用状态", httpMethod = "POST")
    @PostMapping("updateEnableStatus")
    ResponseData<RightsHotelUpdateStatusResponseVO> updateEnableStatus(@RequestBody RightsHotelUpdateStatusRequestVO requestVO);
}
