package com.bizvane.rights.vo.service;

import com.bizvane.rights.consts.BusinessConst;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

@Data
public class RightsBarrierFreeParkingDetailResponseVO implements Serializable {

    @ApiModelProperty("无障碍车位预约记录表code")
    private String rightsBarrierFreeParkingRecordCode;

    @ApiModelProperty("会员code")
    private String mbrMembersCode;

    @ApiModelProperty("商户编号")
    private String merchantNo;

    @ApiModelProperty("预约记录编号")
    private String reservationRecordNo;

    @ApiModelProperty("预约停车场")
    private String parkingLot;

    @ApiModelProperty("车牌号")
    private String licensePlate;

    @ApiModelProperty("联系电话, 敏感信息SM4加密后传输")
    private String contactNumber;

    @ApiModelProperty("联系电话加密")
    private String contactNumberEncrypt;

    @ApiModelProperty("残疾人证件号, 敏感信息SM4加密后传输")
    private String disabilityCardNo;

    @ApiModelProperty("预约时间")
    @JsonFormat(pattern = BusinessConst.YMDHM, timezone = BusinessConst.TIMEZONE)
    private LocalDateTime appointmentTime;

    @ApiModelProperty("预约状态, 1=确认中,2=待使用,3=已完成,4=已取消")
    private Integer appointmentStatus;

    @ApiModelProperty("旅客信息列表")
    private List<RightsSpecialPassengerVO> passengerList;

    @ApiModelProperty("备注(接口保存)")
    private String remarks;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("创建人code")
    private String createUserCode;

    @ApiModelProperty("创建人")
    private String createUserName;

    @ApiModelProperty("创建日期")
    @JsonFormat(pattern = BusinessConst.YMDHMS, timezone = BusinessConst.TIMEZONE)
    private LocalDateTime createDate;

    @ApiModelProperty("修改人code")
    private String modifiedUserCode;

    @ApiModelProperty("修改人")
    private String modifiedUserName;

    @ApiModelProperty("修改时间")
    @JsonFormat(pattern = BusinessConst.YMDHMS, timezone = BusinessConst.TIMEZONE)
    private LocalDateTime modifiedDate;
}
