package com.bizvane.rights.vo.hotel;

import com.bizvane.rights.consts.BusinessConst;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.LocalTime;

@Data
public class RightsHotelDetailResponseVO implements Serializable {

    @ApiModelProperty("酒店主体code")
    private String rightsHotelCode;

    @ApiModelProperty("酒店名称")
    private String hotelName;

    @ApiModelProperty("酒店编码")
    private String hotelCode;

    @ApiModelProperty("酒店电话")
    private String hotelPhone;

    @ApiModelProperty("酒店地址")
    private String hotelAddress;

    @ApiModelProperty("酒店主图(前端传啥存啥)")
    private String mainImage;

    @ApiModelProperty("酒店其他图片(前端传啥存啥)")
    private String otherImage;

    @ApiModelProperty("酒店简介")
    private String hotelSummary;

    @ApiModelProperty("酒店介绍")
    private String hotelIntroduction;

    @ApiModelProperty("酒店入住协议")
    private String hotelAgreement;

    @ApiModelProperty("启用状态 true启用/false禁用")
    private Boolean enableStatus;

    @ApiModelProperty("组织code")
    private String orgCode;

    @ApiModelProperty("经度")
    private String longitude;

    @ApiModelProperty("纬度")
    private String latitude;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("创建人code")
    private String createUserCode;

    @ApiModelProperty("创建人")
    private String createUserName;

    @ApiModelProperty("创建日期")
    @JsonFormat(pattern = BusinessConst.YMDHMS, timezone = BusinessConst.TIMEZONE)
    private LocalDateTime createDate;

    @ApiModelProperty("修改人code")
    private String modifiedUserCode;

    @ApiModelProperty("修改人")
    private String modifiedUserName;

    @ApiModelProperty("修改时间")
    @JsonFormat(pattern = BusinessConst.YMDHMS, timezone = BusinessConst.TIMEZONE)
    private LocalDateTime modifiedDate;

    @ApiModelProperty("最晚取消时间")
    @JsonFormat(pattern = BusinessConst.HMS, timezone = BusinessConst.TIMEZONE)
    private LocalTime latestCancellationTime;
}
