package com.bizvane.rights.vo.transit.benefits;

import com.bizvane.members.feign.model.vo.CouponDefinitionVO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

@Data
public class TransitBenefitsDetailResponseVO implements Serializable {

    @ApiModelProperty("中转权益code")
    private String rightsTransitBenefitsCode;

    @ApiModelProperty("中转服务type 1.国内到达权益 2.国际到达权益 3.国际中转国内权益 4.国际中转国际权益 5.国内中转国内权益 6.国内中转国际权益")
    private Integer rightsType;

    @ApiModelProperty("中转服务名称")
    private String rightsName;

    @ApiModelProperty("权益领取方式：1-权益领取，2-链接跳转")
    private Integer claimMethod;

    @ApiModelProperty("权益类型：1-优惠券")
    private Integer type;

    @ApiModelProperty("链接跳转路径")
    private String linkUrl;

    @ApiModelProperty("是否开启：1-开启，0-关闭")
    private Boolean status;

    @ApiModelProperty("获取规则限制类型：1-日，2-周，3-月，4-年")
    private Integer limitType;

    @ApiModelProperty("获取规则限制次数")
    private Integer limitCount;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("券定义集合")
    private List<CouponDefinitionVO> couponDefinitionVOList;
}
