package com.bizvane.rights.vo.steward;

import com.bizvane.rights.consts.BusinessConst;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.springframework.data.annotation.Version;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 *
 * </p>
 *
 * @author liuying
 * @since 2024-12-09
 */
@Getter
@Setter
@Data
@ApiModel(value = "StewardOrderReqRespVO对象", description = "")
public class StewardOrderReqRespVO implements Serializable {

    @ApiModelProperty("机场管家订单code")
    private String stewardOrderCode;

    @ApiModelProperty("订单编号")
    private String orderNo;


    @ApiModelProperty("订单状态 0: 待支付, 1：待确认, 5已确认,2：服务中, 3已完成, 4 已取消")
    private Integer status;

    @ApiModelProperty("接待员工code")
    private String staffCode;

    @ApiModelProperty("接待员工名称")
    private String staffName;

    @ApiModelProperty("预订人(会员表code)")
    private String mbrMembersCode;

    @ApiModelProperty("预订人名称")
    private String mbrName;

    @ApiModelProperty("预订人电话")
    private String mbrPhone;

    @ApiModelProperty("预订人电话加密")
    private String mbrPhoneEncrypt;

    @ApiModelProperty("预定时间")
    @JsonFormat(pattern = BusinessConst.YMDHMS, timezone = BusinessConst.TIMEZONE)
    private LocalDateTime reservationTime;

    @ApiModelProperty("航班信息表code")
    private String basicFlightCode;

    @ApiModelProperty("航班日期")
    @JsonFormat(pattern = BusinessConst.YMDHMS, timezone = BusinessConst.TIMEZONE)
    private LocalDateTime flightScheduledDate;

    @ApiModelProperty("航班号")
    private String flightIdentity;

    @ApiModelProperty("航空公司名称")
    private String airlineCn;

    @ApiModelProperty("起飞机场")
    private String cnOriginAirport;

    @ApiModelProperty("到达机场")
    private String cnDestinationAirport;

    @ApiModelProperty("关联 t_basic_dict_general")
    private String orderServiceType;

    @ApiModelProperty("服务名称(接机服务，送机服务)")
    private String orderServiceNames;

    @ApiModelProperty("预订总价(原预订价格，优惠价的总价)")
    private BigDecimal reservePrice;

    @ApiModelProperty("优惠金额（优惠券金额）")
    private BigDecimal discountAmount;

    @ApiModelProperty("实付金额")
    private BigDecimal reallyPrice;

    @ApiModelProperty("使用优惠券code")
    private String couponCode;

    @ApiModelProperty("取消类型（1后台取消2用户取消）")
    private Integer cancelType;

    @ApiModelProperty("是否退券0否1是")
    private Integer refundCoupon;

    @ApiModelProperty("预约人姓名")
    private String orderName;

    @ApiModelProperty("预约人电话")
    private String orderMobile;

    @ApiModelProperty("预约人电话加密")
    private String orderMobileEncrypt;




    @ApiModelProperty("预约省份")
    private String orderProvince;

    @ApiModelProperty("预约城市")
    private String orderCity;


    @ApiModelProperty("预约行政区")
    private String orderDistrict;

    @ApiModelProperty("预约详细地址")
    private String orderAddress;

    @ApiModelProperty("预约地址code")
    private String addressCode;

    @ApiModelProperty("下单时间")
    @JsonFormat(pattern = BusinessConst.YMDHMS, timezone = BusinessConst.TIMEZONE)
    private LocalDateTime orderTime;

    @ApiModelProperty("支付时间")
    @JsonFormat(pattern = BusinessConst.YMDHMS, timezone = BusinessConst.TIMEZONE)
    private LocalDateTime payDate;

    @ApiModelProperty("处理说明")
    private String handlingInstructions;

    @ApiModelProperty("退款金额")
    private BigDecimal refundAmount;

    @ApiModelProperty("退款说明")
    private String refundInstructions;

    @ApiModelProperty("支付系统编号流水code")
    private String orderTradeRecordCode;

    @ApiModelProperty("微信支付生成的订单号")
    private String transactionId;

    @ApiModelProperty("退款支付系统编号流水code")
    private String refundOrderTradeRecordCode;

    @ApiModelProperty("退款微信支付生成的订单号")
    private String refundTransactionId;

    @ApiModelProperty("确认人code")
    private String confirmerUserCode;

    @ApiModelProperty("确认人name")
    private String confirmerUserName;

    @ApiModelProperty("确认时间")
    @JsonFormat(pattern = BusinessConst.YMDHMS, timezone = BusinessConst.TIMEZONE)
    private LocalDateTime confirmTime;

    @ApiModelProperty("完成人code")
    private String completeUserCode;

    @ApiModelProperty("完成人name")
    private String completeUserName;

    @ApiModelProperty("完成时间")
    @JsonFormat(pattern = BusinessConst.YMDHMS, timezone = BusinessConst.TIMEZONE)
    private LocalDateTime completeTime;

    @ApiModelProperty("取消人code")
    private String cancellationUserCode;

    @ApiModelProperty("取消人name")
    private String cancellationUserName;

    @ApiModelProperty("取消时间")
    @JsonFormat(pattern = BusinessConst.YMDHMS, timezone = BusinessConst.TIMEZONE)
    private LocalDateTime cancellationTime;

    @ApiModelProperty("公共字段：创建日期，下单时间")
    @JsonFormat(pattern = BusinessConst.YMDHMS, timezone = BusinessConst.TIMEZONE)
    private LocalDateTime createDate;

    @ApiModelProperty("公共字段：创建人编码")
    private String createUserCode;

    @ApiModelProperty("创建人名称")
    private String createUserName;

    @ApiModelProperty("修改日期")
    @JsonFormat(pattern = BusinessConst.YMDHMS, timezone = BusinessConst.TIMEZONE)
    private LocalDateTime modifiedDate;

    @ApiModelProperty("修改人编码")
    private String modifiedUserCode;

    @ApiModelProperty("修改人名称")
    private String modifiedUserName;

}
