package com.bizvane.rights.vo.special;

import com.bizvane.rights.consts.BusinessConst;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.time.LocalDateTime;

@Data
public class RightsSpecialPassengerFlightDetailVO implements Serializable {

    @ApiModelProperty("预计起飞时间")
    @JsonFormat(pattern = BusinessConst.YMDHMS, timezone = BusinessConst.TIMEZONE)
    @DateTimeFormat(pattern = BusinessConst.YMDHMS)
    private LocalDateTime estimatedDepartureTime;

    @ApiModelProperty("航班类型, 1，出发，2到达")
    private Integer flightType;

    @ApiModelProperty("航班编号")
    private String flightNumber;

    @ApiModelProperty("预约地点")
    private String appointmentLocation;
}
