package com.bizvane.rights.vo.parking.barrierfree;

import com.alibaba.fastjson.JSON;
import com.bizvane.rights.consts.BusinessConst;
import com.bizvane.rights.vo.OptUserVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.time.LocalDateTime;

@Data
public class RightsBarrierFreeParkingSaveRequestVO extends OptUserVO implements Serializable {

    @ApiModelProperty("会员code")
    private String mbrMembersCode;

    @ApiModelProperty("商户编号")
    private String merchantNo;

    @ApiModelProperty("预约记录编号")
    private String reservationRecordNo;

    @ApiModelProperty("预约停车场")
    private String parkingLot;

    @ApiModelProperty("车牌号")
    private String licensePlate;

    @ApiModelProperty("联系电话脱敏, 敏感信息SM4加密后传输")
    private String contactNumber;

    @ApiModelProperty("联系电话加密")
    private String contactNumberEncrypt;

    @ApiModelProperty("残疾人证件号, 敏感信息SM4加密后传输")
    private String disabilityCardNo;

    @ApiModelProperty("预约时间")
    @JsonFormat(pattern = BusinessConst.YMDHMS, timezone = BusinessConst.TIMEZONE)
    @DateTimeFormat(pattern = BusinessConst.YMDHMS)
    private LocalDateTime appointmentTime;

    @ApiModelProperty("预约状态, 1=确认中,2=待使用,3=已完成,4=已取消")
    private Integer appointmentStatus;

    @ApiModelProperty("旅客信息列表,jsonArray")
    private String passengerInfo;

    @ApiModelProperty("备注(接口保存)")
    private String remarks;
}
