package com.bizvane.rights.feign;

import com.bizvane.rights.vo.hotel.order.mobile.RightsHotelDetailRequestVO;
import com.bizvane.rights.vo.hotel.order.mobile.RightsHotelDetailResponseVO;
import com.bizvane.rights.vo.hotel.order.mobile.RightsHotelRoomTypeDetailRequestVO;
import com.bizvane.rights.vo.hotel.order.mobile.RightsHotelRoomTypeDetailResponseVO;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * 酒店mobile feign
 *
 * @author liuying
 */
@Api(value = "酒店主体", tags = "酒店主体")
@FeignClient(value = "${feign.client.rights.name}", path = "${feign.client.rights.path}/hotelMobile")
public interface HotelMobileFeign {

    /**
     * 1.酒店code查询酒店信息
     * 2.酒店code + 预定时间 查询房型信息
     * 3.合并 1 + 2 接口
     */
    @ApiOperation(value = "查询酒店明细", notes = "查询酒店明细", httpMethod = "POST")
    @PostMapping("detail")
    ResponseData<RightsHotelDetailResponseVO> detail(@RequestBody RightsHotelDetailRequestVO requestVO);

    @ApiOperation(value = "查询全部列表酒店", notes = "查询全部列表酒店", httpMethod = "GET")
    @PostMapping("listRoomType")
    ResponseData<List<RightsHotelRoomTypeDetailResponseVO>> listRoomType(@RequestBody RightsHotelRoomTypeDetailRequestVO requestVO);

    @ApiOperation(value = "查询酒店房型明细", notes = "查询酒店房型明细", httpMethod = "POST")
    @PostMapping("detailRoomType")
    ResponseData<RightsHotelDetailResponseVO> detailWithRoomType(@RequestBody RightsHotelRoomTypeDetailRequestVO requestVO);
}
