package com.bizvane.rights.vo.hotel.roomsituation;

import com.bizvane.rights.consts.BusinessConst;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDate;

@Data
public class RightsHotelRoomSituationDaysConditionRequestVO implements Serializable {

    @ApiModelProperty("酒店主体code")
    private String rightsHotelCode;

    @ApiModelProperty("开始日期")
    @JsonFormat(pattern = BusinessConst.YMD, timezone = BusinessConst.TIMEZONE)
    private LocalDate startDate;

    @ApiModelProperty("结束日期")
    @JsonFormat(pattern = BusinessConst.YMD, timezone = BusinessConst.TIMEZONE)
    private LocalDate endDate;
}
