package com.bizvane.rights.feign.mobile;

import com.bizvane.rights.vo.steward.StewardOrderMobileReqVO;
import com.bizvane.rights.vo.steward.StewardOrderMobileRespVO;
import com.bizvane.rights.vo.steward.StewardPaymentRespVO;
import com.bizvane.rights.vo.steward.StewardServiceReqRespVO;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;
@FeignClient(value = "${feign.client.rights.name}", path = "${feign.client.rights.path}/stewardMobile")
public interface StewardMobileFeign {
    @ApiOperation(value ="通过机场编码获取机场服务")
    @PostMapping("/findServiceByAirport")
    public List<StewardServiceReqRespVO> findServiceByAirport(StewardOrderMobileReqVO stewardOrderMobileReqVO);
    @ApiOperation(value ="立即支付")
    @PostMapping("/payForOrder")
    public ResponseData<StewardPaymentRespVO> payForOrder(StewardOrderMobileReqVO stewardOrderMobileReqVO);
    @ApiOperation(value ="立即支付后根据订单编码查结果")
    @PostMapping("/resultByOrderCode")
    public ResponseData<StewardOrderMobileRespVO> resultByOrderCode(StewardOrderMobileReqVO stewardOrderMobileReqVO);
    @ApiOperation(value ="确认核销，传入订单编码")
    @PostMapping("/changeStatus")
    public ResponseData<Boolean> changeStatus(@RequestBody StewardOrderMobileReqVO stewardOrderMobileReqVO);
}
