package com.bizvane.rights.feign;

import com.bizvane.rights.vo.hotel.order.*;
import com.bizvane.rights.vo.steward.*;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@Api(value = "管家订单记录", tags = "管家订单记录")
@FeignClient(value = "${feign.client.rights.name}", path = "${feign.client.rights.path}/stewardOrderService")
public interface StewardOrderFeign {
    @ApiOperation(value = "服务列表", notes = "服务列表", httpMethod = "POST")
    @PostMapping("/pageList")
    public ResponseData<PageInfo<StewardOrderReqRespVO>> pageList(@RequestBody StewardOrderQueryReqVO stewardOrderVO);

    @ApiOperation(value = "处理确认订单", notes = "处理确认订单", httpMethod = "POST")
    @PostMapping("processingConfirm")
    ResponseData<StewardOperateOrdersResponseVO> processingConfirm(@RequestBody StewardOperateOrdersRequestVO requestVO);

    @ApiOperation(value = "预定订单改派", notes = "预定订单改派", httpMethod = "POST")
    @PostMapping("orderReassignment")
    ResponseData<StewardOperateOrdersResponseVO> orderReassignment(@RequestBody StewardOperateOrdersRequestVO requestVO);

    @ApiOperation(value = "预定订单取消", notes = "预定订单取消", httpMethod = "POST")
    @PostMapping("orderCancellation")
    ResponseData<StewardOperateOrdersResponseVO> orderCancellation(@RequestBody StewardOperateOrdersRequestVO requestVO);

    @ApiOperation(value = "订单评价", notes = "订单评价", httpMethod = "POST")
    @PostMapping("orderEvaluation")
    ResponseData<StewardOrderWithEvaluateResponseVO> orderEvaluation(@RequestBody StewardOrderWithEvaluateRequestVO requestVO);

    @ApiOperation(value = "订单统计", notes = "订单统计", httpMethod = "POST")
    @PostMapping("statistics")
    ResponseData<StewardOrderStatisticsResponseVo> statistics();
}
