package com.bizvane.rights.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

@AllArgsConstructor
@Getter
public enum EvaluateLabelTypeEnum {


    /**
     * 订单
     */
    BUSINESS_ORDER(1,"商业订单评价","商业订单"),
    PARKING_SERVICE(2,"停车服务评价","停车服务"),
    HOTEL_ORDER(3,"酒店预订评价","酒店预订"),
    VIP_ORDER(4,"贵宾订单评价","贵宾订单"),
    AIRPORT_GUARD(5,"机场管家评价","机场管家"),



    /**
     * 服务
     */
    LUGGAGE_TO_DOOR_SERVICE(6,"行李门到门服务评价","行李门到门服务"),
    BARRIER_FREE_PARKING_SERVICE(7,"无障碍车位服务预约","无障碍车位服务"),
    SPECIAL_TRAVELER_SERVICE(8,"特殊旅客服务评价","特殊旅客服务");


    private Integer code;

    private String desc;
    private String serviceItems;




    public static EvaluateLabelTypeEnum fromCode(Integer code) {
        for (EvaluateLabelTypeEnum type : EvaluateLabelTypeEnum.values()) {
            if (type.getCode().equals(code)) {
                return type;
            }
        }
        return null;
    }



}
