package com.bizvane.platform.feign.feign.basic;


import com.bizvane.platform.feign.model.req.base.BaseUploadReq;
import com.bizvane.platform.feign.model.rsp.BaseUploadInfoRsp;
import com.bizvane.platform.feign.model.rsp.BaseUploadRsp;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@FeignClient(value = "${feign.client.platform.name}", path = "${feign.client.platform.path}" + "/upload")
@Api(value = "文件上传RPC")
public interface BasicUploadRpcFeign {

    @RequestMapping(value = "/getUpload", method = RequestMethod.GET)
    @ApiOperation(value = "获取文件上传信息")
    ResponseData<BaseUploadInfoRsp> getUpload();


    @RequestMapping(value = "/doUpload", method = RequestMethod.POST)
    @ApiOperation(value = "文件上传")
    ResponseData<BaseUploadRsp> doUpload(@RequestBody @Validated BaseUploadReq baseUploadRsp);


}
