package com.bizvane.platform.feign.feign.basic;


import com.bizvane.platform.feign.model.vo.TSysStaffAuthVo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.List;

@FeignClient(value = "${feign.client.platform.name}", path = "${feign.client.platform.path}" + "/tSysStaffAuth")
@Api(value = "员工账号授权RPC")
public interface SysStaffAuthRpcFeign {


    @RequestMapping(value = "/list", method = RequestMethod.POST)
    @ApiOperation(value = "列表")
    ResponseData<List<TSysStaffAuthVo>> list(@RequestBody TSysStaffAuthVo req);

    @RequestMapping(value = "/update", method = RequestMethod.POST)
    @ApiOperation(value = "更新")
    ResponseData<Boolean> update(@RequestBody TSysStaffAuthVo tSysAccountReq);

    @RequestMapping(value = "/detail", method = RequestMethod.POST)
    @ApiOperation(value = "详情")
    ResponseData<TSysStaffAuthVo> detail(@RequestBody TSysStaffAuthVo req);


}
