package com.bizvane.platform.feign.feign.basic;

import com.bizvane.platform.feign.model.req.TSysRolePageReq;
import com.bizvane.platform.feign.model.vo.TSysRoleMenuVO;
import com.bizvane.platform.feign.model.vo.TSysRoleVo;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.List;

@FeignClient(value = "${feign.client.platform.name}", path = "${feign.client.platform.path}" + "/tSysRole")
@Api(value = "角色RPC")
public interface SysRoleRpcFeign {

    @RequestMapping(value = "/getRoleList", method = RequestMethod.POST)
    @ApiOperation(value = "角色列表")
    ResponseData<List<TSysRoleVo>> getRoleList(@RequestBody TSysRoleVo tSysAccountReq);

    @RequestMapping(value = "/updateRoleInfo", method = RequestMethod.POST)
    @ApiOperation(value = "修改角色信息")
    ResponseData<Boolean> updateRoleInfo(@RequestBody TSysRoleVo tSysAccountReq);

    @RequestMapping(value = "/pageList", method = RequestMethod.POST)
    @ApiOperation(value = "分页条件查询列表")
    ResponseData<PageInfo<TSysRoleVo>> pageList(@RequestBody TSysRolePageReq req);

    @RequestMapping(value = "/getRoleMenuAndBtnByRoleCode", method = RequestMethod.POST)
    @ApiOperation(value = "获取角色信息和菜单按钮列表")
    ResponseData<TSysRoleMenuVO> getRoleMenuAndBtnByRoleCode(@RequestBody TSysRoleMenuVO tSysRoleMenuVO);

    @RequestMapping(value = "/saveRoleMenuAndBtn", method = RequestMethod.POST)
    @ApiOperation(value = "保存角色信息和菜单按钮列表")
    ResponseData<Boolean> saveRoleMenuAndBtn(@RequestBody TSysRoleMenuVO tSysRoleMenuVO);

    @RequestMapping(value = "/updateRoleMenuAndBtn", method = RequestMethod.POST)
    @ApiOperation(value = "修改角色信息和菜单按钮列表")
    ResponseData<Boolean> updateRoleMenuAndBtn(@RequestBody TSysRoleMenuVO tSysRoleMenuVO);

}
