/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.openapi.gateway.module.token.service.impl;

import com.alibaba.fastjson.JSON;
import com.bizvane.openapi.authentication.AuthenticationService;
import com.bizvane.openapi.authentication.vo.Client;
import com.bizvane.openapi.authentication.vo.Token;
import com.bizvane.openapi.common.utils.SignatureUtils;
import com.bizvane.openapi.gateway.logging.LogUtil;
import com.bizvane.openapi.gateway.module.cache.GatewayManager;
import com.bizvane.openapi.gateway.module.token.service.OauthManager;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OauthManagerImpl
implements OauthManager {
    @Autowired
    AuthenticationService authenticationService;
    @Autowired
    GatewayManager gatewayManager;

    public Token accessToken(String appKey, String appSecret) {
        LogUtil.tokenLog.info("AccessToken | appkey: {} | appSecret: {}", (Object)appKey, (Object)appSecret);
        Client client = this.gatewayManager.getClient(appKey, appSecret);
        Token accessToken = this.authenticationService.accessToken(client);
        LogUtil.tokenLog.info("AccessToken | appkey: {} | appSecret: {} | token: {}", new Object[]{appKey, appSecret, JSON.toJSONString((Object)accessToken)});
        return accessToken;
    }

    public Token refreshToken(String appKey, String refreshToken) {
        LogUtil.tokenLog.info("RefreshToken | appkey: {} | refreshToken: {}", (Object)appKey, (Object)refreshToken);
        Token accessToken = this.authenticationService.refreshToken(appKey, refreshToken);
        LogUtil.tokenLog.info("RefreshToken | appkey: {} | refreshToken: {} | token: {}", new Object[]{appKey, refreshToken, JSON.toJSONString((Object)accessToken)});
        return accessToken;
    }

    public boolean verifySignature(String sign, String accessToken, Map<String, Object> params) {
        LogUtil.requestLog.info("VerifySignature | accessToken: {} | sign: {} | params: {}", new Object[]{accessToken, sign, JSON.toJSONString(params)});
        boolean verifySignature = this.authenticationService.verifySignature(sign, accessToken, params);
        LogUtil.requestLog.info("VerifySignature | accessToken: {} | sign: {} | result: {}", new Object[]{accessToken, sign, verifySignature});
        return verifySignature;
    }

    public String signatureWithAppKey(String appKey, Map<String, Object> params) {
        return this.authenticationService.signature(appKey, params);
    }

    public String signatureWithAppSecret(String appSecret, Map<String, Object> params) {
        return SignatureUtils.sign((String)appSecret, params);
    }

    public Client getClient(String accessToken) {
        return this.authenticationService.getClient(accessToken);
    }
}

