/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.openapi.gateway.module.request.controller;

import com.alibaba.csp.sentinel.Entry;
import com.alibaba.csp.sentinel.EntryType;
import com.alibaba.csp.sentinel.SphU;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import com.bizvane.openapi.gateway.config.SentinelRulesConfig;
import com.bizvane.openapi.gateway.module.request.service.RequestManager;
import io.swagger.annotations.Api;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedCaseInsensitiveMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.HandlerMapping;

@Api(tags={"\u63a5\u53e3\u8bf7\u6c42"})
@RestController
@RequestMapping(value={"/request"})
public class RequestController {
    @Autowired
    RequestManager requestManager;
    @Autowired
    HttpServletRequest request;

    @PostMapping(value={"/{serviceAlias}/{apiAlias}"})
    public Object request(@PathVariable String serviceAlias, @PathVariable String apiAlias, @RequestHeader Map<String, String> headers, @RequestBody Map<String, Object> body) {
        String currentPath = String.valueOf(this.request.getAttribute(HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE));
        Entry entry = null;
        String entryName = "Service-" + serviceAlias;
        try {
            Object result;
            entry = SphU.entry((String)entryName, (EntryType)EntryType.IN);
            LinkedCaseInsensitiveMap caseInsensitiveHeaders = new LinkedCaseInsensitiveMap();
            caseInsensitiveHeaders.putAll(headers);
            Object object = result = this.requestManager.request(currentPath, serviceAlias, apiAlias, (Map)caseInsensitiveHeaders, body);
            return object;
        }
        catch (BlockException ex) {
            throw SentinelRulesConfig.convert((BlockException)ex);
        }
        finally {
            if (entry != null) {
                entry.exit();
            }
        }
    }
}

