/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.openapi.gateway.module.cache.impl;

import com.bizvane.openapi.authentication.AuthenticationService;
import com.bizvane.openapi.authentication.consts.CodeMessageConsts;
import com.bizvane.openapi.authentication.vo.Client;
import com.bizvane.openapi.business.modules.cache.vo.ServiceApiVO;
import com.bizvane.openapi.business.modules.developeraccount.service.OpenapiDeveloperAccountManager;
import com.bizvane.openapi.business.modules.service.entity.OpenapiServiceInfo;
import com.bizvane.openapi.business.modules.service.service.OpenapiServiceManager;
import com.bizvane.openapi.common.exception.OpenApiExceptionSupplier;
import com.bizvane.openapi.common.response.CodeMessage;
import com.bizvane.openapi.common.utils.Assert;
import com.bizvane.openapi.gateway.consts.CodeMessageConsts;
import com.bizvane.openapi.gateway.module.cache.GatewayManager;
import com.google.common.base.Strings;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.CacheManager;
import org.springframework.stereotype.Service;

@Service
public class GatewayCacheManagerImpl
implements GatewayManager {
    @Autowired
    OpenapiDeveloperAccountManager developerAccountManager;
    @Autowired
    AuthenticationService authenticationService;
    @Autowired
    CacheManager cacheManager;
    @Autowired
    OpenapiServiceManager serviceManager;

    public ServiceApiVO getServiceApi(String serviceAlias, String apiAlias) {
        String key = Strings.lenientFormat((String)"%s-%s", (Object[])new Object[]{serviceAlias, apiAlias});
        Supplier<ServiceApiVO> getInCache = () -> (ServiceApiVO)this.cacheManager.getCache("service_api").get((Object)key, ServiceApiVO.class);
        Supplier<ServiceApiVO> getInDb = () -> {
            ServiceApiVO sav = Optional.ofNullable(this.serviceManager.getServiceApiDetail(serviceAlias, apiAlias)).orElseThrow(OpenApiExceptionSupplier.convert((CodeMessage)CodeMessageConsts.Gateway.INVALID_API_NOTFOUND));
            this.cacheManager.getCache("service_api").put((Object)key, (Object)sav);
            return sav;
        };
        return Optional.ofNullable(getInCache.get()).orElseGet(getInDb);
    }

    public OpenapiServiceInfo getService(String serviceAlias) {
        return null;
    }

    public Client getClient(String appKey, String appSecret) {
        Assert.hasText((String)appKey, (CodeMessage)CodeMessageConsts.Authentication.APP_KEY_EMPTY);
        Assert.hasText((String)appSecret, (CodeMessage)CodeMessageConsts.Authentication.APP_SECRET_EMPTY);
        Client client = this.getClient(appKey);
        Assert.notNull((Object)client, (CodeMessage)CodeMessageConsts.Authentication.INVALID_APP_KEY);
        Assert.isTrue((boolean)appSecret.equals(client.getAppSecret()), (CodeMessage)CodeMessageConsts.Authentication.APPKEY_APPSECRET_MISMATCH);
        return client;
    }

    public Client getClient(String appKey) {
        Assert.notNull((Object)appKey, (CodeMessage)CodeMessageConsts.Authentication.APP_KEY_EMPTY);
        return Optional.ofNullable(this.authenticationService.getClientWithAppKey(appKey)).orElseGet(() -> {
            AtomicReference clientRef = new AtomicReference();
            Optional.ofNullable(this.developerAccountManager.getDeveloperAccount(appKey)).ifPresent(da -> {
                Client client = new Client();
                client.setAppKey(da.getAppKey());
                client.setAppSecret(da.getAppSecret());
                client.addExt("business_id", (Object)da.getBusinessId());
                this.authenticationService.cacheClient(client);
                clientRef.set(client);
            });
            return (Client)clientRef.get();
        });
    }
}

