package com.bizvane.openapifacade.models.vo;

import lombok.Data;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

/**
 * @Author sampson
 * @Date 2021-02-09 16:27
 * @Describe
 */
@Data
public class VGOrderMallRequestVO extends VGOrderRequestVO {
    /**
     * 该笔订单产生的时间点类型(1 下单支付完成，2 过了有效退换货 , 3 过了有效期退换货之后且是第一次发送的整单)
     */
    @Min( value=1 , message = "订单产生的时间点类型值有误" )
    @Max( value=3 , message = "订单产生的时间点类型值有误" )
    @NotNull( message = "该笔订单产生的时间点类型不对")
    private Integer orderBuildType ;

    /**
     * 订单类型(1 整单 ，2 子单)
     */
    @NotNull(message = "订单类型不能为空")
    @Max(value = 2,message = "订单类型有误")
    @Min(value = 1,message = "订单类型有误")
    private Integer orderType ;
}
