package com.bizvane.openapifacade.models.vo;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @Author sampson
 * @Date 2021-03-21 15:19
 * @Describe
 */
@Data
public class VGCouponRulesRequestVO {

    private Long sysCompanyId;
    @NotBlank
    private String brandCode;
    @NotBlank
    private String coupGrpId;
    @NotBlank
    private String coupGrpName;
    private String coupName;
    private String couponName;
    private String useDesc;
    @NotNull
    private Integer validType;
    private String validStartAt;
    private String validEndAt;
    private Integer validDay;
    @NotNull
    private Integer preferentialType;
    private BigDecimal coupValue;
    private BigDecimal amtLimit;
    private BigDecimal disLimit;
    private Integer maxQtyBuy;
    private String allowMoreCoup;
    private String storeLimit;
    private String proLimit;
    private String proForbid;
    private String useBrandCode;

    // 优惠券设置属性-大区，支社
    private Long sysBojunDataId;
    /**
     * 伯俊属性ID
     */
    private String bojunPropId;

    /**
     * 属性名称
     */
    private String propName;

    /**
     *  属性简称
     */
    private String propSimpleName;

    /**
     * 属性code
     */
    private String propCode;

    /**
     * 属性值
     */
    private String propValue;

    /**
     * 属性类型 branch支社 region 大区
     */
    private String propType;

    /**
     * 状态：0=隐藏；1=展示
     */
    private Boolean showStatus;

    /**
     * 备注
     */
    private String remark;

    /**
     * 创建人id
     */
    private Long createUserId;

    /**
     * 创建人
     */
    private String createUserName;

    /**
     * 创建日期
     */
    private Date createDate;

    /**
     * 修改人id
     */
    private Long modifiedUserId;

    /**
     * 修改人
     */
    private String modifiedUserName;

    /**
     * 修改时间
     */
    private Date modifiedDate;

    /**
     * 数据有效性：1=有效；0=无效
     */
    private Boolean valid;
}
