package com.bizvane.openapifacade.models.vo;

import com.bizvane.openapifacade.utils.valid.EnumStringValue;
import com.bizvane.openapifacade.utils.valid.StringBrandCode;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.List;

@Data
public class CommonGoodsRequestVo {

    @NotBlank
    @EnumStringValue(StringBrandCode.class)
    private String brandCode;
    @NotNull
    private String productBrandCode;//	是	string	商品品牌code
    @NotNull
    private String skuCode;//	是	string	sku编号
    @NotNull
    private String productCode;//	是	string	商品编号
    @NotNull
    private String productName;//	是	string	商品名称
    private String productId ; // 商品id
    private BigDecimal priceSug;//	否	string	吊牌价
    private BigDecimal marketPrice;//	否	string	市场价（销售价）
    private String unit;//	否	string	单位
    private String cata1Code;//	按需	string	大类code
    private String cata1Desc;//	按需	string	大类描述
    private String cata2Code;//	按需	string	中类code
    private String cata2Desc;//	按需	string	中类描述
    private String cata3Code;//	否	string	小类代码
    private String cata3Desc;//	否	string	小类描述
    private List<CommonGoodsSkuApiInfo> properties;//	否	string	商品属性Json格式 :1 year_prd:年份 2 season_prd:季节 3 type_prd:类型 4 band_prd:波段 5 fabelement:面料成份 6 上下装；7 系列；8 子系列；9 性别
    private List<CommonGoodsSkuApiInfo> specifications;//	否	string	商品规格Json格式（如果需要扩展，继续定义类型） 1 颜色 2尺寸
    private String extJson;//	否	string	json商品扩展值
    private String timeToMarket;//	否	string	上市时间，格式yyyy-MM-dd

    private List<CommonGoodsSkuApiInfo> property_json;

    private List<CommonGoodsSkuApiInfo> specification_json;


//    String addinterfaceAll4 = "syncGoods,燕之屋商品,/openapi.api/yanzhiwu/goods/syncGoods";
//    String addParamList14 = "productBrandCode,商品品牌code&skuCode,sku编号&productCode,商品编号&productName,商品名称&priceSug,吊牌价&marketPrice,市场价" +
//            "&unit,单位&cata1Code,大类code&cata1Desc,大类描述&cata2Code,中类code&cata2Desc,中类描述&cata3Code,小类代码&cata3Desc,小类描述&properties,商品属性Json格式&" +
//            "specifications,商品规格Json格式&extJson,json商品扩展值&timeToMarket,上市时间";

}
