package com.bizvane.openapifacade.models.vo;

import com.bizvane.openapifacade.utils.valid.EnumStringValue;
import com.bizvane.openapifacade.utils.valid.StringBrandCode;
import lombok.Data;

import javax.validation.constraints.NotEmpty;

@Data
public class ChangeCardLevelRequestVo {
    @NotEmpty
    @EnumStringValue(StringBrandCode.class)
    private String brandCode;
    @NotEmpty
    private String cardNo;
    @NotEmpty
    private String oldLevelCode;
    @NotEmpty
    private String newLevelCode;
    private String detail;
//    String addinterfaceAll = "vgqchangeCardLevel,VG会员卡等级变更,/customized.api/vg/changeCardLevel";
//    String addParamList1 = "brandCode,品牌code&cardNo,会员集团卡号&oldLevelCode,变更前的卡等级&newLevelCode,变更后的卡等级&detail,详情";


    @Override
    public String toString() {
        return "ChangeCardLevelRequestVo{" +
                "brandCode='" + brandCode + '\'' +
                ", cardNo='" + cardNo + '\'' +
                ", oldLevelCode='" + oldLevelCode + '\'' +
                ", newLevelCode='" + newLevelCode + '\'' +
                ", detail='" + detail + '\'' +
                '}';
    }
}
