package com.bizvane.openapifacade.models.vo;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;

/**
 * 订单Model中的券信息
 * @Author sampson
 * @Date 2021-01-26 16:44
 * @Describe
 */
@AllArgsConstructor
@NoArgsConstructor
@Builder
@Data
public class VGOrderUsedCouponVO {
    /**
     * 优惠券Code
     */
    private String couponCode;
    /**
     * 券名称
     */
    private String couponName;
    /**
     * 券类型code（1.现金券 2.折扣券）
     */
    private String couponTypeCode;
    /**
     * 券类型名称
     */
    private String couponTypeName;
    /**
     * 优惠券核销金额
     */
    private BigDecimal couponAmount;
    /**
     * 券使用说明
     */
    private String description;

}
