package com.bizvane.openapifacade.models.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;


/**
 * @author baofeng@bizvane.cn
 * @createTime 2021-10-18 10:32:38
 * @description: 优惠券查询条件对象
 */
@AllArgsConstructor
@NoArgsConstructor
@Builder
@Data
public class CouponQueryDTO {
    @ApiModelProperty(name = "cardCode", value = "会员卡号", required = true, example = "")
    @NotBlank(message = "会员卡号不能为空")
    private String cardCode;

    @ApiModelProperty(name = "brandId", value = "品牌ID", required = false, example = "")
    @NotNull(message = "品牌ID不能为空")
    @Min(value = 0)
    private Long brandId;

    @ApiModelProperty(name = "corpId", value = "企业ID,即sysCompanyId", required = false, example = "")
    @Min(value = 0)
    private Long corpId;

    @ApiModelProperty(name = "status", value = "5-线上绑定，10-同步中，11-同步失败，12-同步成功，20-未使用，25-已过期，30-已核销", required = false, example = "")
    private Integer status;

}
