package com.bizvane.openapifacade.models.vo;

import lombok.Data;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

/**
 * <p>
 * 361会员完善资料接口请求参数model
 * </p>
 * @author dingShiChen
 * @since 2019/10/15
 */
@Data
public class MemberPerfectDataRequestVO {

	/*
		品牌编号
	 */
	@NotEmpty
	private String brandCode;

	/*
		请求来源:1.POS(门店) 2.官网3 4.微信 5.天猫 6.其他
	 */
	@NotNull
	private Integer originRequest;

	/*
		会员原始手机号
	 */
	@NotEmpty
	private String phone;

	/*
		线下id
 	*/
	@NotEmpty
	private String erpid;

	/*
		会员姓名
	 */
	private String newName;

	/*
		会员手机号
	 */
	private String newPhone;

	/*
		会员性别（1女、2男、3，未知，默认未知）
	 */
	private String newSex;

	/*
		省
	 */
	private String newProvince;

	/*
		市
	 */
	private String newCity;

	/*
		区
	 */
	private String newCounty;

	/*
		会员详细地址
	 */
	private String newAddress;

	/*
		备注
	 */
	private String newRemark;

	/*
		会员邮箱
	 */
	private String newEmail;

	/*
		会员身份证号
	 */
	private String newIdCard;

	/*
		会员生日 格式：yyyy-MM-dd
	 */
	private String newBirthday;

	/*
		等级code
	 */
	private String newLevelCode;
}
